/*
 * Decompiled with CFR 0.152.
 */
package io.littlehorse.sdk.common.config;

import io.littlehorse.sdk.common.exception.ConfigurationFileException;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigBase {
    private static final Logger log = LoggerFactory.getLogger(ConfigBase.class);
    protected Properties props;

    public ConfigBase(String propLocation) {
        log.info("Loading config from {}", (Object)propLocation);
        this.props = new Properties();
        try {
            this.props.load(new FileInputStream(propLocation));
        }
        catch (IOException e) {
            throw new ConfigurationFileException(e);
        }
    }

    public ConfigBase(Properties props) {
        this.props = props;
    }

    public ConfigBase(Map<String, Object> configs) {
        this.props = new Properties();
        this.props.putAll(configs);
    }

    public ConfigBase() {
        this.props = new Properties();
        log.info("Loading default config from environment");
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            for (String prefix : this.getEnvKeyPrefixes()) {
                if (!entry.getKey().startsWith(prefix)) continue;
                this.props.setProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    protected abstract String[] getEnvKeyPrefixes();

    protected String getOrSetDefault(String key, String defaultVal) {
        if (!this.props.containsKey(key)) {
            log.warn("Config: {} unset, defaulting to: {}", (Object)key, (Object)defaultVal);
            if (defaultVal != null) {
                this.props.setProperty(key, defaultVal);
            }
            return defaultVal;
        }
        return String.valueOf(this.props.get(key));
    }
}

