/*
 * Decompiled with CFR 0.152.
 */
package io.littlehorse.sdk.common.auth;

import io.grpc.CallCredentials;
import io.grpc.Metadata;
import io.grpc.Status;
import io.littlehorse.sdk.common.auth.OAuthClient;
import io.littlehorse.sdk.common.auth.TokenStatus;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthCredentialsProvider
extends CallCredentials {
    private static final Logger log = LoggerFactory.getLogger(OAuthCredentialsProvider.class);
    private static final Metadata.Key<String> AUTHORIZATION_HEADER_KEY = Metadata.Key.of((String)"Authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private final OAuthClient oauthClient;
    private TokenStatus currentToken;

    public OAuthCredentialsProvider(OAuthClient oauthClient) {
        this.oauthClient = oauthClient;
    }

    public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor executor, CallCredentials.MetadataApplier metadataApplier) {
        executor.execute(() -> {
            try {
                if (this.currentToken == null || !this.currentToken.isValid()) {
                    this.currentToken = this.oauthClient.getAccessToken();
                }
                Metadata headers = new Metadata();
                headers.put(AUTHORIZATION_HEADER_KEY, (Object)String.format("Bearer %s", this.currentToken.getToken()));
                metadataApplier.apply(headers);
            }
            catch (Exception e) {
                log.error("Error when getting access token", (Throwable)e);
                metadataApplier.fail(Status.UNAUTHENTICATED.withCause((Throwable)e));
            }
        });
    }
}

