/*
 * Decompiled with CFR 0.152.
 */
package io.littlehorse.sdk.common.auth;

import java.net.URI;

public class OAuthConfig {
    private final String clientId;
    private final String clientSecret;
    private final URI tokenEndpointURI;

    OAuthConfig(String clientId, String clientSecret, URI tokenEndpointURI) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.tokenEndpointURI = tokenEndpointURI;
    }

    public static OAuthConfigBuilder builder() {
        return new OAuthConfigBuilder();
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public URI getTokenEndpointURI() {
        return this.tokenEndpointURI;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuthConfig)) {
            return false;
        }
        OAuthConfig other = (OAuthConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        URI this$tokenEndpointURI = this.getTokenEndpointURI();
        URI other$tokenEndpointURI = other.getTokenEndpointURI();
        return !(this$tokenEndpointURI == null ? other$tokenEndpointURI != null : !((Object)this$tokenEndpointURI).equals(other$tokenEndpointURI));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OAuthConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        URI $tokenEndpointURI = this.getTokenEndpointURI();
        result = result * 59 + ($tokenEndpointURI == null ? 43 : ((Object)$tokenEndpointURI).hashCode());
        return result;
    }

    public static class OAuthConfigBuilder {
        private String clientId;
        private String clientSecret;
        private URI tokenEndpointURI;

        OAuthConfigBuilder() {
        }

        public OAuthConfigBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public OAuthConfigBuilder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public OAuthConfigBuilder tokenEndpointURI(URI tokenEndpointURI) {
            this.tokenEndpointURI = tokenEndpointURI;
            return this;
        }

        public OAuthConfig build() {
            return new OAuthConfig(this.clientId, this.clientSecret, this.tokenEndpointURI);
        }

        public String toString() {
            return "OAuthConfig.OAuthConfigBuilder(clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", tokenEndpointURI=" + this.tokenEndpointURI + ")";
        }
    }
}

