/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.parser;

import io.lindstrom.m3u8.model.MasterPlaylist;
import io.lindstrom.m3u8.parser.AbstractPlaylistParser;
import io.lindstrom.m3u8.parser.MasterPlaylistTag;
import io.lindstrom.m3u8.parser.ParsingMode;
import io.lindstrom.m3u8.parser.PlaylistParserException;
import io.lindstrom.m3u8.parser.TextBuilder;
import io.lindstrom.m3u8.parser.VariantAttribute;
import java.util.Iterator;

public class MasterPlaylistParser
extends AbstractPlaylistParser<MasterPlaylist, MasterPlaylist.Builder> {
    private final ParsingMode parsingMode;

    public MasterPlaylistParser() {
        this(ParsingMode.STRICT);
    }

    public MasterPlaylistParser(ParsingMode parsingMode) {
        this.parsingMode = parsingMode;
    }

    @Override
    void write(MasterPlaylist playlist, TextBuilder textBuilder) {
        for (MasterPlaylistTag tag : MasterPlaylistTag.tags.values()) {
            tag.write(playlist, textBuilder);
        }
    }

    @Override
    MasterPlaylist.Builder newBuilder() {
        return MasterPlaylist.builder();
    }

    @Override
    void onTag(MasterPlaylist.Builder builder, String name, String attributes, Iterator<String> lineIterator) throws PlaylistParserException {
        MasterPlaylistTag tag = MasterPlaylistTag.tags.get(name);
        if (tag == MasterPlaylistTag.EXT_X_STREAM_INF) {
            String uriLine = lineIterator.next();
            if (uriLine == null || uriLine.startsWith("#")) {
                throw new PlaylistParserException("Expected URI, got " + uriLine);
            }
            builder.addVariants(VariantAttribute.parse(attributes, uriLine, this.parsingMode));
        } else if (tag != null) {
            tag.read(builder, attributes, this.parsingMode);
        } else if (this.parsingMode.failOnUnknownTags()) {
            throw new PlaylistParserException("Tag not implemented: " + name);
        }
    }

    @Override
    void onComment(MasterPlaylist.Builder builder, String value) {
        builder.addComments(value);
    }

    @Override
    MasterPlaylist build(MasterPlaylist.Builder builder) {
        return builder.build();
    }
}

