/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.swagger.mountpoints;

import com.google.common.base.Optional;
import io.lighty.swagger.impl.BaseYangSwaggerGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.core.UriInfo;
import org.opendaylight.controller.md.sal.dom.api.DOMMountPoint;
import org.opendaylight.controller.md.sal.dom.api.DOMMountPointService;
import org.opendaylight.controller.sal.core.api.model.SchemaService;
import org.opendaylight.controller.sal.core.api.mount.MountProvisionListener;
import org.opendaylight.netconf.sal.rest.doc.swagger.Api;
import org.opendaylight.netconf.sal.rest.doc.swagger.ApiDeclaration;
import org.opendaylight.netconf.sal.rest.doc.swagger.Operation;
import org.opendaylight.netconf.sal.rest.doc.swagger.Resource;
import org.opendaylight.netconf.sal.rest.doc.swagger.ResourceList;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public class MountPointSwagger
extends BaseYangSwaggerGenerator
implements MountProvisionListener {
    private static final String DATASTORES_REVISION = "-";
    private static final String DATASTORES_LABEL = "Datastores";
    private static final String RESTCONF_DRAFT = "18";
    private static final AtomicReference<MountPointSwagger> SELF_REF = new AtomicReference();
    private DOMMountPointService mountService;
    private final Map<YangInstanceIdentifier, Long> instanceIdToLongId = new TreeMap<YangInstanceIdentifier, Long>((o1, o2) -> o1.toString().compareToIgnoreCase(o2.toString()));
    private final Map<Long, YangInstanceIdentifier> longIdToInstanceId = new HashMap<Long, YangInstanceIdentifier>();
    private final Object lock = new Object();
    private final AtomicLong idKey = new AtomicLong(0L);
    private SchemaService globalSchema;
    private static boolean newDraft;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Long> getInstanceIdentifiers() {
        HashMap<String, Long> urlToId = new HashMap<String, Long>();
        Object object = this.lock;
        synchronized (object) {
            SchemaContext context = this.globalSchema.getGlobalContext();
            for (Map.Entry<YangInstanceIdentifier, Long> entry : this.instanceIdToLongId.entrySet()) {
                String modName = this.findModuleName(entry.getKey(), context);
                urlToId.put(this.generateUrlPrefixFromInstanceID(entry.getKey(), modName), entry.getValue());
            }
        }
        return urlToId;
    }

    public void setGlobalSchema(SchemaService globalSchema) {
        this.globalSchema = globalSchema;
    }

    private String findModuleName(YangInstanceIdentifier id, SchemaContext context) {
        YangInstanceIdentifier.PathArgument rootQName = (YangInstanceIdentifier.PathArgument)id.getPathArguments().iterator().next();
        for (Module mod : context.getModules()) {
            if (mod.getDataChildByName(rootQName.getNodeType()) == null) continue;
            return mod.getName();
        }
        return null;
    }

    private String generateUrlPrefixFromInstanceID(YangInstanceIdentifier key, String moduleName) {
        StringBuilder builder = new StringBuilder();
        builder.append("/");
        if (moduleName != null) {
            builder.append(moduleName).append(':');
        }
        for (YangInstanceIdentifier.PathArgument arg : key.getPathArguments()) {
            String name = arg.getNodeType().getLocalName();
            if (arg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
                YangInstanceIdentifier.NodeIdentifierWithPredicates nodeId = (YangInstanceIdentifier.NodeIdentifierWithPredicates)arg;
                for (Map.Entry entry : nodeId.getKeyValues().entrySet()) {
                    if (newDraft) {
                        builder.deleteCharAt(builder.length() - 1).append("=").append(entry.getValue()).append('/');
                        continue;
                    }
                    builder.append(entry.getValue()).append('/');
                }
                continue;
            }
            builder.append(name).append('/');
        }
        return builder.toString();
    }

    private String getYangMountUrl(YangInstanceIdentifier key) {
        String modName = this.findModuleName(key, this.globalSchema.getGlobalContext());
        return this.generateUrlPrefixFromInstanceID(key, modName) + "yang-ext:mount";
    }

    public ResourceList getResourceList(UriInfo uriInfo, Long id) {
        YangInstanceIdentifier iid = this.getInstanceId(id);
        if (iid == null) {
            return null;
        }
        SchemaContext context = this.getSchemaContext(iid);
        if (context == null) {
            return this.createResourceList();
        }
        LinkedList<Resource> resources = new LinkedList<Resource>();
        Resource dataStores = new Resource();
        dataStores.setDescription("Provides methods for accessing the data stores.");
        dataStores.setPath(this.generatePath(uriInfo, DATASTORES_LABEL, DATASTORES_REVISION));
        resources.add(dataStores);
        String urlPrefix = this.getYangMountUrl(iid);
        ResourceList list = super.getResourceListing(uriInfo, context, urlPrefix);
        resources.addAll(list.getApis());
        list.setApis(resources);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private YangInstanceIdentifier getInstanceId(Long id) {
        YangInstanceIdentifier instanceId;
        Object object = this.lock;
        synchronized (object) {
            instanceId = this.longIdToInstanceId.get(id);
        }
        return instanceId;
    }

    private SchemaContext getSchemaContext(YangInstanceIdentifier id) {
        if (id == null) {
            return null;
        }
        Optional mountPoint = this.mountService.getMountPoint(id);
        if (!mountPoint.isPresent()) {
            return null;
        }
        SchemaContext context = ((DOMMountPoint)mountPoint.get()).getSchemaContext();
        if (context == null) {
            return null;
        }
        return context;
    }

    public ApiDeclaration getMountPointApi(UriInfo uriInfo, Long id, String module, String revision) {
        YangInstanceIdentifier iid = this.getInstanceId(id);
        SchemaContext context = this.getSchemaContext(iid);
        String urlPrefix = this.getYangMountUrl(iid);
        if (context == null) {
            return null;
        }
        if (DATASTORES_LABEL.equals(module) && DATASTORES_REVISION.equals(revision)) {
            return this.generateDataStoreApiDoc(uriInfo, urlPrefix);
        }
        return super.getApiDeclaration(module, revision, uriInfo, context, urlPrefix);
    }

    private ApiDeclaration generateDataStoreApiDoc(UriInfo uriInfo, String context) {
        LinkedList<Api> apis = new LinkedList<Api>();
        apis.add(this.createGetApi("config", "Queries the config (startup) datastore on the mounted hosted.", context));
        apis.add(this.createGetApi("operational", "Queries the operational (running) datastore on the mounted hosted.", context));
        apis.add(this.createGetApi("operations", "Queries the available operations (RPC calls) on the mounted hosted.", context));
        ApiDeclaration declaration = super.createApiDeclaration(this.createBasePathFromUriInfo(uriInfo));
        declaration.setApis(apis);
        return declaration;
    }

    private Api createGetApi(String datastore, String note, String context) {
        Operation getConfig = new Operation();
        getConfig.setMethod("GET");
        getConfig.setNickname("GET " + datastore);
        getConfig.setNotes(note);
        Api api = new Api();
        api.setPath(this.getDataStorePath(datastore, context).concat(MountPointSwagger.getContent(datastore)));
        api.setOperations(Collections.singletonList(getConfig));
        return api;
    }

    public void setMountService(DOMMountPointService mountService) {
        this.mountService = mountService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMountPointCreated(YangInstanceIdentifier path) {
        Object object = this.lock;
        synchronized (object) {
            Long idLong = this.idKey.incrementAndGet();
            this.instanceIdToLongId.put(path, idLong);
            this.longIdToInstanceId.put(idLong, path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMountPointRemoved(YangInstanceIdentifier path) {
        Object object = this.lock;
        synchronized (object) {
            Long id = this.instanceIdToLongId.remove(path);
            this.longIdToInstanceId.remove(id);
        }
    }

    public static MountPointSwagger getInstance() {
        MountPointSwagger swagger = SELF_REF.get();
        if (swagger == null) {
            SELF_REF.compareAndSet(null, new MountPointSwagger());
            swagger = SELF_REF.get();
        }
        newDraft = false;
        return swagger;
    }

    public static MountPointSwagger getInstanceDraft18() {
        MountPointSwagger swagger = SELF_REF.get();
        if (swagger == null) {
            SELF_REF.compareAndSet(null, new MountPointSwagger());
            swagger = SELF_REF.get();
        }
        newDraft = true;
        return swagger;
    }
}

