/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.swagger.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.ws.rs.core.UriInfo;
import org.opendaylight.netconf.sal.rest.doc.impl.ModelGenerator;
import org.opendaylight.netconf.sal.rest.doc.model.builder.OperationBuilder;
import org.opendaylight.netconf.sal.rest.doc.swagger.Api;
import org.opendaylight.netconf.sal.rest.doc.swagger.ApiDeclaration;
import org.opendaylight.netconf.sal.rest.doc.swagger.Operation;
import org.opendaylight.netconf.sal.rest.doc.swagger.Parameter;
import org.opendaylight.netconf.sal.rest.doc.swagger.Resource;
import org.opendaylight.netconf.sal.rest.doc.swagger.ResourceList;
import org.opendaylight.netconf.sal.rest.doc.util.RestDocgenUtil;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseYangSwaggerGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(org.opendaylight.netconf.sal.rest.doc.impl.BaseYangSwaggerGenerator.class);
    protected static final String API_VERSION = "1.0.0";
    protected static final String SWAGGER_VERSION = "1.2";
    protected static final String RESTCONF_CONTEXT_ROOT = "restconf";
    private static final String RESTCONF_DRAFT = "18";
    static final String MODULE_NAME_SUFFIX = "_module";
    private final ModelGenerator jsonConverter = new ModelGenerator();
    private final ObjectMapper mapper = new ObjectMapper();
    private static boolean newDraft;

    protected BaseYangSwaggerGenerator() {
        this.mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
    }

    public ResourceList getResourceListing(UriInfo uriInfo, SchemaContext schemaContext, String context) {
        ResourceList resourceList = this.createResourceList();
        SortedSet<Module> modules = this.getSortedModules(schemaContext);
        ArrayList<Resource> resources = new ArrayList<Resource>(modules.size());
        LOG.info("Modules found [{}]", (Object)modules.size());
        for (Module module : modules) {
            String revisionString = module.getQNameModule().getRevision().map(Revision::toString).orElse(null);
            Resource resource = new Resource();
            LOG.debug("Working on [{},{}]...", (Object)module.getName(), (Object)revisionString);
            ApiDeclaration doc = this.getApiDeclaration(module.getName(), revisionString, uriInfo, schemaContext, context);
            if (doc != null) {
                resource.setPath(this.generatePath(uriInfo, module.getName(), revisionString));
                resources.add(resource);
                continue;
            }
            LOG.warn("Could not generate doc for {},{}", (Object)module.getName(), (Object)revisionString);
        }
        resourceList.setApis(resources);
        return resourceList;
    }

    protected ResourceList createResourceList() {
        ResourceList resourceList = new ResourceList();
        resourceList.setApiVersion(API_VERSION);
        resourceList.setSwaggerVersion(SWAGGER_VERSION);
        return resourceList;
    }

    protected String generatePath(UriInfo uriInfo, String name, String revision) {
        URI uri = uriInfo.getRequestUriBuilder().path(BaseYangSwaggerGenerator.generateCacheKey(name, revision)).build(new Object[0]);
        return uri.toASCIIString();
    }

    public ApiDeclaration getApiDeclaration(String moduleName, String revision, UriInfo uriInfo, SchemaContext schemaContext, String context) {
        Optional rev;
        try {
            rev = Revision.ofNullable((String)revision);
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException(e);
        }
        Module module = schemaContext.findModule(moduleName, rev).orElse(null);
        Preconditions.checkArgument((module != null ? 1 : 0) != 0, (Object)("Could not find module by name,revision: " + moduleName + "," + revision));
        return this.getApiDeclaration(module, uriInfo, context, schemaContext);
    }

    public ApiDeclaration getApiDeclaration(Module module, UriInfo uriInfo, String context, SchemaContext schemaContext) {
        String basePath = this.createBasePathFromUriInfo(uriInfo);
        ApiDeclaration doc = this.getSwaggerDocSpec(module, basePath, context, schemaContext);
        if (doc != null) {
            return doc;
        }
        return null;
    }

    protected String createBasePathFromUriInfo(UriInfo uriInfo) {
        String portPart = "";
        int port = uriInfo.getBaseUri().getPort();
        if (port != -1) {
            portPart = ":" + port;
        }
        String basePath = uriInfo.getBaseUri().getScheme() + "://" + uriInfo.getBaseUri().getHost() + portPart + "/" + RESTCONF_CONTEXT_ROOT;
        return basePath;
    }

    public ApiDeclaration getSwaggerDocSpec(Module module, String basePath, String context, SchemaContext schemaContext) {
        String resourcePath;
        ApiDeclaration doc = this.createApiDeclaration(basePath);
        ArrayList<Api> apis = new ArrayList<Api>();
        boolean hasAddRootPostLink = false;
        Collection dataSchemaNodes = module.getChildNodes();
        LOG.debug("child nodes size [{}]", (Object)dataSchemaNodes.size());
        for (Object node : dataSchemaNodes) {
            if (!(node instanceof ListSchemaNode) && !(node instanceof ContainerSchemaNode)) continue;
            LOG.debug("Is Configuration node [{}] [{}]", (Object)node.isConfiguration(), (Object)node.getQName().getLocalName());
            ArrayList<Parameter> pathParams = new ArrayList<Parameter>();
            if (node.isConfiguration()) {
                resourcePath = this.getDataStorePath("config", context);
                if (!hasAddRootPostLink) {
                    LOG.debug("Has added root post link for module {}", (Object)module.getName());
                    BaseYangSwaggerGenerator.addRootPostLink(module, (DataNodeContainer)node, pathParams, resourcePath, "config", apis);
                    hasAddRootPostLink = true;
                }
                this.addApis((DataSchemaNode)node, apis, resourcePath, pathParams, schemaContext, true, module.getName(), "config");
            }
            pathParams = new ArrayList();
            resourcePath = this.getDataStorePath("operational", context);
            this.addApis((DataSchemaNode)node, apis, resourcePath, pathParams, schemaContext, false, module.getName(), "operational");
        }
        Set rpcs = module.getRpcs();
        for (RpcDefinition rpcDefinition : rpcs) {
            resourcePath = this.getDataStorePath("operations", context);
            this.addRpcs(rpcDefinition, apis, resourcePath, schemaContext);
        }
        LOG.debug("Number of APIs found [{}]", (Object)apis.size());
        if (!apis.isEmpty()) {
            doc.setApis(apis);
            ObjectNode models = null;
            try {
                models = this.jsonConverter.convertToJsonSchema(module, schemaContext);
                doc.setModels(models);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.mapper.writeValueAsString((Object)doc));
                }
            }
            catch (IOException e) {
                LOG.error("Exception occured in ModelGenerator", (Throwable)e);
            }
            return doc;
        }
        return null;
    }

    private static void addRootPostLink(Module module, DataNodeContainer node, List<Parameter> pathParams, String resourcePath, String dataStore, List<Api> apis) {
        if (BaseYangSwaggerGenerator.containsListOrContainer(module.getChildNodes())) {
            Api apiForRootPostUri = new Api();
            apiForRootPostUri.setPath(resourcePath.concat(BaseYangSwaggerGenerator.getContent(dataStore)));
            apiForRootPostUri.setOperations(BaseYangSwaggerGenerator.operationPost(module.getName() + MODULE_NAME_SUFFIX, module.getDescription().orElse(null), (DataNodeContainer)module, pathParams, true, ""));
            apis.add(apiForRootPostUri);
        }
    }

    protected ApiDeclaration createApiDeclaration(String basePath) {
        ApiDeclaration doc = new ApiDeclaration();
        doc.setApiVersion(API_VERSION);
        doc.setSwaggerVersion(SWAGGER_VERSION);
        doc.setBasePath(basePath);
        doc.setProduces(Arrays.asList("application/json", "application/xml"));
        return doc;
    }

    protected String getDataStorePath(String dataStore, String context) {
        if (newDraft) {
            if ("config".contains(dataStore) || "operational".contains(dataStore)) {
                return "/data" + context;
            }
            return "/operations" + context;
        }
        return "/" + dataStore + context;
    }

    private static String generateCacheKey(String module, String revision) {
        return module + "(" + revision + ")";
    }

    private void addApis(DataSchemaNode node, List<Api> apis, String parentPath, List<Parameter> parentPathParams, SchemaContext schemaContext, boolean addConfigApi, String parentName, String dataStore) {
        Api api = new Api();
        ArrayList<Parameter> pathParams = new ArrayList<Parameter>(parentPathParams);
        String resourcePath = parentPath + "/" + BaseYangSwaggerGenerator.createPath(node, pathParams, schemaContext);
        LOG.debug("Adding path: [{}]", (Object)resourcePath);
        api.setPath(resourcePath.concat(BaseYangSwaggerGenerator.getContent(dataStore)));
        Set<DataSchemaNode> childSchemaNodes = Collections.emptySet();
        if (node instanceof ListSchemaNode || node instanceof ContainerSchemaNode) {
            DataNodeContainer dataNodeContainer = (DataNodeContainer)node;
            childSchemaNodes = dataNodeContainer.getChildNodes();
        }
        api.setOperations(BaseYangSwaggerGenerator.operation(node, pathParams, addConfigApi, childSchemaNodes, parentName));
        apis.add(api);
        for (DataSchemaNode childNode : childSchemaNodes) {
            if (!(childNode instanceof ListSchemaNode) && !(childNode instanceof ContainerSchemaNode) || childNode.isConfiguration() != addConfigApi) continue;
            String newParent = parentName + "/" + node.getQName().getLocalName();
            this.addApis(childNode, apis, resourcePath, pathParams, schemaContext, addConfigApi, newParent, dataStore);
        }
    }

    protected static String getContent(String dataStore) {
        if (newDraft) {
            if ("operational".contains(dataStore)) {
                return "?content=nonconfig";
            }
            if ("config".contains(dataStore)) {
                return "?content=config";
            }
            return "";
        }
        return "";
    }

    private static boolean containsListOrContainer(Iterable<DataSchemaNode> nodes) {
        for (DataSchemaNode child : nodes) {
            if (!(child instanceof ListSchemaNode) && !(child instanceof ContainerSchemaNode)) continue;
            return true;
        }
        return false;
    }

    private static List<Operation> operation(DataSchemaNode node, List<Parameter> pathParams, boolean isConfig, Iterable<DataSchemaNode> childSchemaNodes, String parentName) {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        OperationBuilder.Get getBuilder = new OperationBuilder.Get(node, isConfig);
        operations.add(getBuilder.pathParams(pathParams).build());
        if (isConfig) {
            OperationBuilder.Put putBuilder = new OperationBuilder.Put(node.getQName().getLocalName(), (String)node.getDescription().orElse(null), parentName);
            operations.add(putBuilder.pathParams(pathParams).build());
            OperationBuilder.Delete deleteBuilder = new OperationBuilder.Delete(node);
            operations.add(deleteBuilder.pathParams(pathParams).build());
            if (BaseYangSwaggerGenerator.containsListOrContainer(childSchemaNodes)) {
                operations.addAll(BaseYangSwaggerGenerator.operationPost(node.getQName().getLocalName(), node.getDescription().orElse(null), (DataNodeContainer)node, pathParams, isConfig, parentName + "/"));
            }
        }
        return operations;
    }

    private static List<Operation> operationPost(String name, String description, DataNodeContainer dataNodeContainer, List<Parameter> pathParams, boolean isConfig, String parentName) {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        if (isConfig) {
            OperationBuilder.Post postBuilder = new OperationBuilder.Post(name, parentName + name, description, dataNodeContainer);
            operations.add(postBuilder.pathParams(pathParams).build());
        }
        return operations;
    }

    private static String createPath(DataSchemaNode schemaNode, List<Parameter> pathParams, SchemaContext schemaContext) {
        ArrayList<LeafSchemaNode> pathListParams = new ArrayList<LeafSchemaNode>();
        StringBuilder path = new StringBuilder();
        String localName = RestDocgenUtil.resolvePathArgumentsName((SchemaNode)schemaNode, (SchemaContext)schemaContext);
        path.append(localName);
        if (schemaNode instanceof ListSchemaNode) {
            List listKeys = ((ListSchemaNode)schemaNode).getKeyDefinition();
            StringBuilder keyBuilder = null;
            if (newDraft) {
                keyBuilder = new StringBuilder("=");
            }
            for (QName listKey : listKeys) {
                DataSchemaNode dataChildByName = ((DataNodeContainer)schemaNode).getDataChildByName(listKey);
                pathListParams.add((LeafSchemaNode)dataChildByName);
                String pathParamIdentifier = newDraft ? keyBuilder.append("{").append(listKey.getLocalName()).append("}").toString() : "/{" + listKey.getLocalName() + "}";
                path.append(pathParamIdentifier);
                Parameter pathParam = new Parameter();
                pathParam.setName(listKey.getLocalName());
                pathParam.setDescription((String)dataChildByName.getDescription().orElse(null));
                pathParam.setType("string");
                pathParam.setParamType("path");
                pathParams.add(pathParam);
                if (!newDraft) continue;
                keyBuilder = new StringBuilder(",");
            }
        }
        return path.toString();
    }

    protected void addRpcs(RpcDefinition rpcDefn, List<Api> apis, String parentPath, SchemaContext schemaContext) {
        Api rpc = new Api();
        String resourcePath = parentPath + "/" + RestDocgenUtil.resolvePathArgumentsName((SchemaNode)rpcDefn, (SchemaContext)schemaContext);
        rpc.setPath(resourcePath);
        Operation operationSpec = new Operation();
        operationSpec.setMethod("POST");
        operationSpec.setNotes((String)rpcDefn.getDescription().orElse(null));
        operationSpec.setNickname(rpcDefn.getQName().getLocalName());
        if (!rpcDefn.getOutput().getChildNodes().isEmpty()) {
            operationSpec.setType("(" + rpcDefn.getQName().getLocalName() + ")output" + "-TOP");
        }
        if (!rpcDefn.getInput().getChildNodes().isEmpty()) {
            Parameter payload = new Parameter();
            payload.setParamType("body");
            payload.setType("(" + rpcDefn.getQName().getLocalName() + ")input" + "-TOP");
            operationSpec.setParameters(Collections.singletonList(payload));
            operationSpec.setConsumes(OperationBuilder.CONSUMES_PUT_POST);
        }
        rpc.setOperations(Arrays.asList(operationSpec));
        apis.add(rpc);
    }

    protected SortedSet<Module> getSortedModules(SchemaContext schemaContext) {
        if (schemaContext == null) {
            return new TreeSet<Module>();
        }
        Set modules = schemaContext.getModules();
        TreeSet<Module> sortedModules = new TreeSet<Module>((module1, module2) -> {
            int result = module1.getName().compareTo(module2.getName());
            if (result == 0) {
                result = Revision.compare((Optional)module1.getRevision(), (Optional)module2.getRevision());
            }
            if (result == 0) {
                result = module1.getNamespace().compareTo(module2.getNamespace());
            }
            return result;
        });
        for (Module m : modules) {
            if (m == null) continue;
            sortedModules.add(m);
        }
        return sortedModules;
    }

    public void setDraft(boolean draft) {
        newDraft = draft;
    }
}

