/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.swagger.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import io.lighty.swagger.impl.ApiDocGenerator;
import io.lighty.swagger.mountpoints.MountPointSwagger;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opendaylight.netconf.sal.rest.doc.api.ApiDocService;
import org.opendaylight.netconf.sal.rest.doc.swagger.ApiDeclaration;
import org.opendaylight.netconf.sal.rest.doc.swagger.ResourceList;

public class ApiDocServiceImpl
implements ApiDocService {
    private static final ApiDocService INSTANCE = new ApiDocServiceImpl();

    public static ApiDocService getInstance() {
        return INSTANCE;
    }

    public synchronized Response getRootDoc(UriInfo uriInfo) {
        ApiDocGenerator generator = ApiDocGenerator.getInstance();
        if (ApiDocServiceImpl.isNew(uriInfo)) {
            generator.setDraft(true);
        } else {
            generator.setDraft(false);
        }
        ResourceList rootDoc = generator.getResourceListing(uriInfo);
        return Response.ok((Object)rootDoc).build();
    }

    public synchronized Response getDocByModule(String module, String revision, UriInfo uriInfo) {
        ApiDocGenerator generator = ApiDocGenerator.getInstance();
        if (ApiDocServiceImpl.isNew(uriInfo)) {
            generator.setDraft(true);
        } else {
            generator.setDraft(false);
        }
        ApiDeclaration doc = generator.getApiDeclaration(module, revision, uriInfo);
        return Response.ok((Object)doc).build();
    }

    public synchronized Response getApiExplorer(UriInfo uriInfo) {
        return Response.seeOther((URI)uriInfo.getBaseUriBuilder().path("../explorer/index.html").build(new Object[0])).build();
    }

    public synchronized Response getListOfMounts(UriInfo uriInfo) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (OutputStreamWriter streamWriter = new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8);){
            JsonGenerator writer = new JsonFactory().createGenerator((Writer)streamWriter);
            writer.writeStartArray();
            for (Map.Entry<String, Long> entry : MountPointSwagger.getInstance().getInstanceIdentifiers().entrySet()) {
                writer.writeStartObject();
                writer.writeObjectField("instance", (Object)entry.getKey());
                writer.writeObjectField("id", (Object)entry.getValue());
                writer.writeEndObject();
            }
            writer.writeEndArray();
            writer.flush();
        }
        catch (Exception e) {
            return Response.status((int)500).entity((Object)e.getMessage()).build();
        }
        return Response.status((int)200).entity((Object)baos.toString()).build();
    }

    public synchronized Response getMountRootDoc(String instanceNum, UriInfo uriInfo) {
        ResourceList resourceList = ApiDocServiceImpl.isNew(uriInfo) ? MountPointSwagger.getInstanceDraft18().getResourceList(uriInfo, Long.parseLong(instanceNum)) : MountPointSwagger.getInstance().getResourceList(uriInfo, Long.parseLong(instanceNum));
        return Response.ok((Object)resourceList).build();
    }

    public synchronized Response getMountDocByModule(String instanceNum, String module, String revision, UriInfo uriInfo) {
        ApiDeclaration api = ApiDocServiceImpl.isNew(uriInfo) ? MountPointSwagger.getInstanceDraft18().getMountPointApi(uriInfo, Long.parseLong(instanceNum), module, revision) : MountPointSwagger.getInstance().getMountPointApi(uriInfo, Long.parseLong(instanceNum), module, revision);
        return Response.ok((Object)api).build();
    }

    private static boolean isNew(UriInfo uriInfo) {
        return true;
    }
}

