/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.swagger;

import com.sun.jersey.spi.container.servlet.ServletContainer;
import io.lighty.core.controller.api.AbstractLightyModule;
import io.lighty.core.controller.api.LightyServices;
import io.lighty.server.LightyServerBuilder;
import io.lighty.swagger.DocProvider;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerLighty
extends AbstractLightyModule {
    private static final Logger LOG = LoggerFactory.getLogger(SwaggerLighty.class);
    private final LightyServerBuilder jettyServerBuilder;
    private final LightyServices lightyServices;

    public SwaggerLighty(LightyServerBuilder jettyServerBuilder, LightyServices lightyServices) {
        this.jettyServerBuilder = jettyServerBuilder;
        this.lightyServices = lightyServices;
    }

    protected boolean initProcedure() {
        LOG.info("initializing swagger ...");
        DocProvider docProvider = new DocProvider(this.lightyServices.getSchemaService(), this.lightyServices.getDOMMountPointService());
        LOG.info("initializing swagger doc generator at http(s)://{hostname:port}/apidoc/apis");
        ServletHolder jaxrs = new ServletHolder(ServletContainer.class);
        jaxrs.setInitParameter("javax.ws.rs.Application", "io.lighty.swagger.jaxrs.ApiDocApplication");
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        ServletContextHandler mainHandler = new ServletContextHandler((HandlerContainer)contexts, "/apidoc", true, false);
        mainHandler.addServlet(jaxrs, "/apis/*");
        LOG.info("initializing swagger UI at: http(s)://{hostname:port}/apidoc/explorer/index.html");
        String externalResource = SwaggerLighty.class.getResource("/18/explorer").toExternalForm();
        DefaultServlet defaultServlet = new DefaultServlet();
        ServletHolder holderPwd = new ServletHolder("static-content", (Servlet)defaultServlet);
        holderPwd.setInitParameter("resourceBase", externalResource);
        holderPwd.setInitParameter("dirAllowed", "true");
        holderPwd.setInitParameter("pathInfoOnly", "true");
        holderPwd.setInitParameter("redirectWelcome", "true");
        mainHandler.addServlet(holderPwd, "/explorer/*");
        LOG.info("adding context handler ...");
        this.jettyServerBuilder.addContextHandler((Handler)contexts);
        return true;
    }

    protected boolean stopProcedure() {
        LOG.info("shutting down swagger ...");
        return true;
    }
}

