/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.swagger;

import io.lighty.swagger.impl.ApiDocGenerator;
import io.lighty.swagger.mountpoints.MountPointSwagger;
import java.util.LinkedList;
import java.util.List;
import org.opendaylight.controller.md.sal.dom.api.DOMMountPointService;
import org.opendaylight.controller.sal.core.api.model.SchemaService;
import org.opendaylight.controller.sal.core.api.mount.MountProvisionListener;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DocProvider.class);
    private final List<AutoCloseable> toClose = new LinkedList<AutoCloseable>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocProvider(SchemaService schemaService, DOMMountPointService mountService) {
        ApiDocGenerator.getInstance().setSchemaService(schemaService);
        ListenerRegistration registration = mountService.registerProvisionListener((MountProvisionListener)MountPointSwagger.getInstance());
        MountPointSwagger.getInstance().setGlobalSchema(schemaService);
        List<AutoCloseable> list = this.toClose;
        synchronized (list) {
            this.toClose.add((AutoCloseable)registration);
        }
        MountPointSwagger.getInstance().setMountService(mountService);
        LOG.debug("Restconf API Explorer started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        List<AutoCloseable> list = this.toClose;
        synchronized (list) {
            for (AutoCloseable close : this.toClose) {
                close.close();
            }
        }
    }
}

