/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.swagger;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opendaylight.netconf.sal.rest.doc.api.ApiDocService;
import org.opendaylight.netconf.sal.rest.doc.mountpoints.MountPointSwagger;
import org.opendaylight.netconf.sal.rest.doc.swagger.ApiDeclaration;
import org.opendaylight.netconf.sal.rest.doc.swagger.ResourceList;

public abstract class ApiDocServiceLightyImpl
implements ApiDocService {
    private final MountPointSwagger mountPointSwagger;

    public ApiDocServiceLightyImpl(MountPointSwagger mountPointSwagger) {
        this.mountPointSwagger = mountPointSwagger;
    }

    public synchronized Response getListOfMounts(UriInfo uriInfo) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (OutputStreamWriter streamWriter = new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8);
             JsonGenerator writer = new JsonFactory().createGenerator((Writer)streamWriter);){
            writer.writeStartArray();
            for (Map.Entry entry : this.mountPointSwagger.getInstanceIdentifiers().entrySet()) {
                writer.writeStartObject();
                writer.writeObjectField("instance", entry.getKey());
                writer.writeObjectField("id", entry.getValue());
                writer.writeEndObject();
            }
            writer.writeEndArray();
            writer.flush();
        }
        catch (IOException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
        try {
            String responseStr = baos.toString(StandardCharsets.UTF_8.name());
            return Response.status((Response.Status)Response.Status.OK).entity((Object)responseStr).build();
        }
        catch (UnsupportedEncodingException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    public synchronized Response getMountRootDoc(String instanceNum, UriInfo uriInfo) {
        ResourceList resourceList = this.mountPointSwagger.getResourceList(uriInfo, Long.valueOf(Long.parseLong(instanceNum)));
        return Response.ok((Object)resourceList).build();
    }

    public synchronized Response getMountDocByModule(String instanceNum, String module, String revision, UriInfo uriInfo) {
        ApiDeclaration api = this.mountPointSwagger.getMountPointApi(uriInfo, Long.valueOf(Long.parseLong(instanceNum)), module, revision);
        return Response.ok((Object)api).build();
    }
}

