/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.modules.northbound.restconf.community.impl;

import com.sun.jersey.spi.container.servlet.ServletContainer;
import io.lighty.core.controller.api.AbstractLightyModule;
import io.lighty.modules.northbound.restconf.community.impl.config.JsonRestConfServiceType;
import io.lighty.server.LightyServerBuilder;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.opendaylight.controller.md.sal.dom.api.DOMDataBroker;
import org.opendaylight.controller.md.sal.dom.api.DOMMountPointService;
import org.opendaylight.controller.md.sal.dom.api.DOMNotificationService;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcService;
import org.opendaylight.controller.sal.core.api.model.SchemaService;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.netconf.sal.restconf.impl.RestconfProviderImpl;
import org.opendaylight.restconf.nb.rfc8040.RestConnectorProvider;
import org.opendaylight.restconf.nb.rfc8040.services.wrapper.ServiceWrapper;
import org.opendaylight.restconf.nb.rfc8040.services.wrapper.ServicesWrapperImpl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommunityRestConf
extends AbstractLightyModule {
    private static final String JAVAX_WS_RS_APPLICATION = "javax.ws.rs.Application";
    private static final Logger LOG = LoggerFactory.getLogger(CommunityRestConf.class);
    private final DOMDataBroker domDataBroker;
    private final SchemaService schemaService;
    private final DOMRpcService domRpcService;
    private final DOMNotificationService domNotificationService;
    private final DOMMountPointService domMountPointService;
    private final PortNumber webSocketPort;
    private final JsonRestConfServiceType jsonRestconfServiceType;
    private final DOMSchemaService domSchemaService;
    private final int httpPort;
    private final InetAddress inetAddress;
    private final String restconfServletContextPath;
    private RestconfProviderImpl restconfProvider;
    private RestConnectorProvider<ServicesWrapperImpl> restConnectorProvider;
    private Server jettyServer;
    private LightyServerBuilder lightyServerBuilder;

    public CommunityRestConf(DOMDataBroker domDataBroker, SchemaService schemaService, DOMRpcService domRpcService, DOMNotificationService domNotificationService, DOMMountPointService domMountPointService, int webSocketPort, JsonRestConfServiceType jsonRestconfServiceType, DOMSchemaService domSchemaService, InetAddress inetAddress, int httpPort, String restconfServletContextPath, ExecutorService executorService, LightyServerBuilder serverBuilder) {
        this.domDataBroker = domDataBroker;
        this.schemaService = schemaService;
        this.domRpcService = domRpcService;
        this.domNotificationService = domNotificationService;
        this.domMountPointService = domMountPointService;
        this.lightyServerBuilder = serverBuilder;
        this.webSocketPort = new PortNumber(Integer.valueOf(webSocketPort));
        this.jsonRestconfServiceType = jsonRestconfServiceType;
        this.domSchemaService = domSchemaService;
        this.httpPort = httpPort;
        this.inetAddress = inetAddress;
        this.restconfServletContextPath = restconfServletContextPath;
    }

    public CommunityRestConf(DOMDataBroker domDataBroker, SchemaService schemaService, DOMRpcService domRpcService, DOMNotificationService domNotificationService, DOMMountPointService domMountPointService, int webSocketPort, JsonRestConfServiceType jsonRestconfServiceType, DOMSchemaService domSchemaService, InetAddress inetAddress, int httpPort, String restconfServletContextPath, ExecutorService executorService) {
        this(domDataBroker, schemaService, domRpcService, domNotificationService, domMountPointService, webSocketPort, jsonRestconfServiceType, domSchemaService, inetAddress, httpPort, restconfServletContextPath, executorService, null);
    }

    protected boolean initProcedure() {
        long startTime = System.nanoTime();
        LOG.info("Starting RestConfProvider websocket port: {}", (Object)this.webSocketPort);
        this.restconfProvider = new RestconfProviderImpl(this.domDataBroker, this.schemaService, this.domRpcService, this.domNotificationService, this.domMountPointService, this.domSchemaService, IpAddressBuilder.getDefaultInstance((String)this.inetAddress.getHostAddress()), this.webSocketPort);
        this.restconfProvider.start();
        LOG.info("Starting RestConnectorProvider");
        this.restConnectorProvider = new RestConnectorProvider(this.domDataBroker, (DOMSchemaService)this.schemaService, this.domRpcService, this.domNotificationService, this.domMountPointService, (ServiceWrapper)ServicesWrapperImpl.getInstance());
        this.restConnectorProvider.start();
        ServletHolder jaxrs = new ServletHolder(ServletContainer.class);
        LOG.info("Starting jsonRestconfService {}", (Object)this.jsonRestconfServiceType.name());
        switch (this.jsonRestconfServiceType) {
            case DRAFT_02: {
                jaxrs.setInitParameter(JAVAX_WS_RS_APPLICATION, "org.opendaylight.netconf.sal.rest.impl.RestconfApplication");
                break;
            }
            case DRAFT_18: {
                jaxrs.setInitParameter(JAVAX_WS_RS_APPLICATION, "org.opendaylight.restconf.nb.rfc8040.RestconfApplication");
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported restconf service type: " + this.jsonRestconfServiceType.name());
            }
        }
        LOG.info("RestConf init complete, starting Jetty");
        LOG.info("http address:port {}:{}, url prefix: {}", new Object[]{this.inetAddress.toString(), this.httpPort, this.restconfServletContextPath});
        try {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(this.inetAddress, this.httpPort);
            ContextHandlerCollection contexts = new ContextHandlerCollection();
            ServletContextHandler mainHandler = new ServletContextHandler((HandlerContainer)contexts, this.restconfServletContextPath, true, false);
            mainHandler.addServlet(jaxrs, "/*");
            boolean startDefault = false;
            if (this.lightyServerBuilder == null) {
                this.lightyServerBuilder = new LightyServerBuilder(inetSocketAddress);
                startDefault = true;
            }
            this.lightyServerBuilder.addContextHandler((Handler)contexts);
            if (startDefault) {
                this.startServer();
            }
        }
        catch (Exception e) {
            LOG.error("Failed to start jetty: ", (Throwable)e);
        }
        float delay = (float)(System.nanoTime() - startTime) / 1000000.0f;
        LOG.info("Lighty RestConf started in {}ms", (Object)Float.valueOf(delay));
        return true;
    }

    protected boolean stopProcedure() {
        boolean stopFailed = false;
        if (this.restConnectorProvider != null) {
            try {
                this.restConnectorProvider.close();
                LOG.info("RestConnectorProvider closed");
            }
            catch (Exception e) {
                LOG.error("{} failed to close!", this.restConnectorProvider.getClass(), (Object)e);
                stopFailed = true;
            }
        }
        if (this.restconfProvider != null) {
            this.restconfProvider.close();
            LOG.info("RestconfProvider closed");
        }
        if (this.jettyServer != null) {
            try {
                this.jettyServer.stop();
                LOG.info("Jetty stopped");
            }
            catch (Exception e) {
                LOG.error("{} failed to stop!", this.jettyServer.getClass(), (Object)e);
                stopFailed = true;
            }
        }
        if (this.lightyServerBuilder != null) {
            this.lightyServerBuilder = null;
        }
        return !stopFailed;
    }

    public void startServer() {
        if (this.jettyServer != null && !this.jettyServer.isStopped()) {
            return;
        }
        try {
            this.jettyServer = this.lightyServerBuilder.build();
            this.jettyServer.start();
            LOG.info("Jetty started");
        }
        catch (Exception e) {
            LOG.error("Failed to start jetty: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

