/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.modules.northbound.restconf.community.impl;

import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import io.lighty.core.controller.api.AbstractLightyModule;
import io.lighty.modules.northbound.restconf.community.impl.root.resource.discovery.RootFoundApplication;
import io.lighty.modules.northbound.restconf.community.impl.util.RestConfConfigUtils;
import io.lighty.server.LightyServerBuilder;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import javax.servlet.Servlet;
import javax.ws.rs.core.Application;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.opendaylight.mdsal.dom.api.DOMActionService;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.mdsal.dom.api.DOMNotificationService;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.restconf.nb.rfc8040.RestconfApplication;
import org.opendaylight.restconf.nb.rfc8040.databind.DatabindProvider;
import org.opendaylight.restconf.nb.rfc8040.databind.mdsal.DOMDatabindProvider;
import org.opendaylight.restconf.nb.rfc8040.handlers.SchemaContextHandler;
import org.opendaylight.restconf.nb.rfc8040.streams.StreamsConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommunityRestConf
extends AbstractLightyModule {
    private static final Logger LOG = LoggerFactory.getLogger(CommunityRestConf.class);
    private final DOMDataBroker domDataBroker;
    private final DOMRpcService domRpcService;
    private final DOMNotificationService domNotificationService;
    private final DOMMountPointService domMountPointService;
    private final DOMActionService domActionService;
    private final DOMSchemaService domSchemaService;
    private final int httpPort;
    private final InetAddress inetAddress;
    private final String restconfServletContextPath;
    private Server jettyServer;
    private LightyServerBuilder lightyServerBuilder;
    private SchemaContextHandler schemaCtxHandler;

    public CommunityRestConf(DOMDataBroker domDataBroker, DOMRpcService domRpcService, DOMActionService domActionService, DOMNotificationService domNotificationService, DOMMountPointService domMountPointService, DOMSchemaService domSchemaService, InetAddress inetAddress, int httpPort, String restconfServletContextPath, LightyServerBuilder serverBuilder) {
        this.domDataBroker = domDataBroker;
        this.domRpcService = domRpcService;
        this.domActionService = domActionService;
        this.domNotificationService = domNotificationService;
        this.domMountPointService = domMountPointService;
        this.lightyServerBuilder = serverBuilder;
        this.domSchemaService = domSchemaService;
        this.httpPort = httpPort;
        this.inetAddress = inetAddress;
        this.restconfServletContextPath = restconfServletContextPath;
    }

    public CommunityRestConf(DOMDataBroker domDataBroker, DOMRpcService domRpcService, DOMActionService domActionService, DOMNotificationService domNotificationService, DOMMountPointService domMountPointService, DOMSchemaService domSchemaService, InetAddress inetAddress, int httpPort, String restconfServletContextPath) {
        this(domDataBroker, domRpcService, domActionService, domNotificationService, domMountPointService, domSchemaService, inetAddress, httpPort, restconfServletContextPath, null);
    }

    protected boolean initProcedure() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        StreamsConfiguration streamsConfiguration = RestConfConfigUtils.getStreamsConfiguration();
        LOG.info("Starting RestconfApplication with configuration {}", (Object)streamsConfiguration);
        this.schemaCtxHandler = new SchemaContextHandler(this.domDataBroker, this.domSchemaService);
        DOMDatabindProvider databindProvider = new DOMDatabindProvider(this.domSchemaService);
        RestconfApplication restconfApplication = new RestconfApplication((DatabindProvider)databindProvider, this.domMountPointService, this.domDataBroker, this.domRpcService, this.domActionService, this.domNotificationService, this.domSchemaService, streamsConfiguration);
        ServletContainer servletContainer8040 = new ServletContainer(ResourceConfig.forApplication((Application)restconfApplication));
        ServletHolder jaxrs = new ServletHolder((Servlet)servletContainer8040);
        LOG.info("RestConf init complete, starting Jetty");
        LOG.info("http address:port {}:{}, url prefix: {}", new Object[]{this.inetAddress.toString(), this.httpPort, this.restconfServletContextPath});
        try {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(this.inetAddress, this.httpPort);
            ContextHandlerCollection contexts = new ContextHandlerCollection();
            ServletContextHandler mainHandler = new ServletContextHandler((HandlerContainer)contexts, this.restconfServletContextPath, true, false);
            mainHandler.addServlet(jaxrs, "/*");
            ServletContextHandler rrdHandler = new ServletContextHandler((HandlerContainer)contexts, "/.well-known", true, false);
            RootFoundApplication rootDiscoveryApp = new RootFoundApplication(this.restconfServletContextPath);
            rrdHandler.addServlet(new ServletHolder((Servlet)new ServletContainer(ResourceConfig.forApplication((Application)rootDiscoveryApp))), "/*");
            boolean startDefault = false;
            if (this.lightyServerBuilder == null) {
                this.lightyServerBuilder = new LightyServerBuilder(inetSocketAddress);
                startDefault = true;
            }
            this.lightyServerBuilder.addContextHandler((Handler)contexts);
            if (startDefault) {
                this.startServer();
            }
        }
        catch (IllegalStateException e) {
            LOG.error("Failed to start jetty: ", (Throwable)e);
        }
        LOG.info("Lighty RestConf started in {}", (Object)stopwatch.stop());
        return true;
    }

    protected boolean stopProcedure() {
        boolean stopFailed = false;
        if (this.schemaCtxHandler != null) {
            this.schemaCtxHandler.close();
            LOG.info("Schema context handler closed");
        }
        if (this.jettyServer != null) {
            try {
                this.jettyServer.stop();
                LOG.info("Jetty stopped");
            }
            catch (Exception e) {
                LOG.error("{} failed to stop!", this.jettyServer.getClass(), (Object)e);
                stopFailed = true;
            }
        }
        if (this.lightyServerBuilder != null) {
            this.lightyServerBuilder = null;
        }
        return !stopFailed;
    }

    public void startServer() {
        if (this.jettyServer != null && !this.jettyServer.isStopped()) {
            return;
        }
        try {
            this.jettyServer = this.lightyServerBuilder.build();
            this.jettyServer.start();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IllegalStateException("Failed to start jetty!", e);
        }
        LOG.info("Jetty started");
    }
}

