/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.modules.northbound.restconf.community.impl.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.lighty.modules.northbound.restconf.community.impl.config.JsonRestConfServiceType;
import java.net.InetAddress;
import java.util.Objects;
import org.opendaylight.mdsal.dom.api.DOMActionService;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.mdsal.dom.api.DOMNotificationService;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;

public class RestConfConfiguration {
    @JsonIgnore
    private DOMDataBroker domDataBroker;
    @JsonIgnore
    private DOMSchemaService schemaService;
    @JsonIgnore
    private DOMRpcService domRpcService;
    @JsonIgnore
    private DOMActionService domActionService;
    @JsonIgnore
    private DOMNotificationService domNotificationService;
    @JsonIgnore
    private DOMMountPointService domMountPointService;
    @JsonIgnore
    private DOMSchemaService domSchemaService;
    private InetAddress inetAddress = InetAddress.getLoopbackAddress();
    private int webSocketPort = 8185;
    private JsonRestConfServiceType jsonRestconfServiceType = JsonRestConfServiceType.DRAFT_18;
    private int httpPort = 8888;
    private String restconfServletContextPath = "/restconf";

    public RestConfConfiguration() {
    }

    public RestConfConfiguration(RestConfConfiguration restConfConfiguration) {
        this.inetAddress = restConfConfiguration.getInetAddress();
        this.webSocketPort = restConfConfiguration.getWebSocketPort();
        this.httpPort = restConfConfiguration.getHttpPort();
        this.restconfServletContextPath = restConfConfiguration.getRestconfServletContextPath();
        this.domDataBroker = restConfConfiguration.getDomDataBroker();
        this.schemaService = restConfConfiguration.getSchemaService();
        this.domRpcService = restConfConfiguration.getDomRpcService();
        this.domActionService = restConfConfiguration.getDomActionService();
        this.domNotificationService = restConfConfiguration.getDomNotificationService();
        this.domMountPointService = restConfConfiguration.getDomMountPointService();
        this.domSchemaService = restConfConfiguration.getDomSchemaService();
        this.jsonRestconfServiceType = restConfConfiguration.getJsonRestconfServiceType();
    }

    public RestConfConfiguration(DOMDataBroker domDataBroker, DOMSchemaService schemaService, DOMRpcService domRpcService, DOMActionService domActionService, DOMNotificationService domNotificationService, DOMMountPointService domMountPointService, DOMSchemaService domSchemaService) {
        this.domDataBroker = domDataBroker;
        this.schemaService = schemaService;
        this.domRpcService = domRpcService;
        this.domActionService = domActionService;
        this.domNotificationService = domNotificationService;
        this.domMountPointService = domMountPointService;
        this.domSchemaService = domSchemaService;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public void setInetAddress(InetAddress inetAddress) {
        this.inetAddress = inetAddress;
    }

    public DOMDataBroker getDomDataBroker() {
        return this.domDataBroker;
    }

    public void setDomDataBroker(DOMDataBroker domDataBroker) {
        this.domDataBroker = domDataBroker;
    }

    public DOMSchemaService getSchemaService() {
        return this.schemaService;
    }

    public void setSchemaService(DOMSchemaService schemaService) {
        this.schemaService = schemaService;
    }

    public DOMRpcService getDomRpcService() {
        return this.domRpcService;
    }

    public void setDomRpcService(DOMRpcService domRpcService) {
        this.domRpcService = domRpcService;
    }

    public DOMActionService getDomActionService() {
        return this.domActionService;
    }

    public void setDomActionService(DOMActionService domActionService) {
        this.domActionService = domActionService;
    }

    public DOMNotificationService getDomNotificationService() {
        return this.domNotificationService;
    }

    public void setDomNotificationService(DOMNotificationService domNotificationService) {
        this.domNotificationService = domNotificationService;
    }

    public DOMMountPointService getDomMountPointService() {
        return this.domMountPointService;
    }

    public void setDomMountPointService(DOMMountPointService domMountPointService) {
        this.domMountPointService = domMountPointService;
    }

    public int getWebSocketPort() {
        return this.webSocketPort;
    }

    public void setWebSocketPort(int webSocketPort) {
        this.webSocketPort = webSocketPort;
    }

    public JsonRestConfServiceType getJsonRestconfServiceType() {
        return this.jsonRestconfServiceType;
    }

    public void setJsonRestconfServiceType(JsonRestConfServiceType jsonRestconfServiceType) {
        this.jsonRestconfServiceType = jsonRestconfServiceType;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public String getRestconfServletContextPath() {
        return this.restconfServletContextPath;
    }

    public void setRestconfServletContextPath(String restconfServletContextPath) {
        this.restconfServletContextPath = restconfServletContextPath;
    }

    public DOMSchemaService getDomSchemaService() {
        return this.domSchemaService;
    }

    public void setDomSchemaService(DOMSchemaService domSchemaService) {
        this.domSchemaService = domSchemaService;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RestConfConfiguration that = (RestConfConfiguration)obj;
        return this.webSocketPort == that.webSocketPort && this.httpPort == that.httpPort && Objects.equals(this.domDataBroker, that.domDataBroker) && Objects.equals(this.schemaService, that.schemaService) && Objects.equals(this.domRpcService, that.domRpcService) && Objects.equals(this.domNotificationService, that.domNotificationService) && Objects.equals(this.domMountPointService, that.domMountPointService) && Objects.equals(this.domSchemaService, that.domSchemaService) && Objects.equals(this.inetAddress, that.inetAddress) && this.jsonRestconfServiceType == that.jsonRestconfServiceType && Objects.equals(this.restconfServletContextPath, that.restconfServletContextPath);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.domDataBroker, this.schemaService, this.domRpcService, this.domNotificationService, this.domMountPointService, this.domSchemaService, this.inetAddress, this.webSocketPort, this.jsonRestconfServiceType, this.httpPort, this.restconfServletContextPath});
    }
}

