/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.modules.northbound.restconf.community.impl;

import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import io.lighty.core.controller.api.AbstractLightyModule;
import io.lighty.modules.northbound.restconf.community.impl.config.JsonRestConfServiceType;
import io.lighty.server.LightyServerBuilder;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;
import javax.servlet.Servlet;
import javax.ws.rs.core.Application;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.opendaylight.mdsal.dom.api.DOMActionService;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.mdsal.dom.api.DOMNotificationService;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.netconf.sal.restconf.impl.BrokerFacade;
import org.opendaylight.netconf.sal.restconf.impl.ControllerContext;
import org.opendaylight.netconf.sal.restconf.impl.RestconfImpl;
import org.opendaylight.netconf.sal.restconf.impl.RestconfProviderImpl;
import org.opendaylight.netconf.sal.restconf.impl.StatisticsRestconfServiceWrapper;
import org.opendaylight.restconf.nb.rfc8040.RestconfApplication;
import org.opendaylight.restconf.nb.rfc8040.handlers.ActionServiceHandler;
import org.opendaylight.restconf.nb.rfc8040.handlers.DOMDataBrokerHandler;
import org.opendaylight.restconf.nb.rfc8040.handlers.DOMMountPointServiceHandler;
import org.opendaylight.restconf.nb.rfc8040.handlers.NotificationServiceHandler;
import org.opendaylight.restconf.nb.rfc8040.handlers.RpcServiceHandler;
import org.opendaylight.restconf.nb.rfc8040.handlers.SchemaContextHandler;
import org.opendaylight.restconf.nb.rfc8040.handlers.TransactionChainHandler;
import org.opendaylight.restconf.nb.rfc8040.services.wrapper.ServicesWrapper;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommunityRestConf
extends AbstractLightyModule {
    private static final Logger LOG = LoggerFactory.getLogger(CommunityRestConf.class);
    private final DOMDataBroker domDataBroker;
    private final DOMRpcService domRpcService;
    private final DOMNotificationService domNotificationService;
    private final DOMMountPointService domMountPointService;
    private final DOMActionService domActionService;
    private final PortNumber webSocketPort;
    private final JsonRestConfServiceType jsonRestconfServiceType;
    private final DOMSchemaService domSchemaService;
    private final int httpPort;
    private final InetAddress inetAddress;
    private final String restconfServletContextPath;
    private RestconfImpl restconfImpl;
    private BrokerFacade brokerFacade;
    private ControllerContext controllerContext;
    private RestconfProviderImpl restconfProvider;
    private Server jettyServer;
    private LightyServerBuilder lightyServerBuilder;

    public CommunityRestConf(DOMDataBroker domDataBroker, DOMSchemaService schemaService, DOMRpcService domRpcService, DOMActionService domActionService, DOMNotificationService domNotificationService, DOMMountPointService domMountPointService, int webSocketPort, JsonRestConfServiceType jsonRestconfServiceType, DOMSchemaService domSchemaService, InetAddress inetAddress, int httpPort, String restconfServletContextPath, ExecutorService executorService, LightyServerBuilder serverBuilder) {
        this.domDataBroker = domDataBroker;
        this.domRpcService = domRpcService;
        this.domActionService = domActionService;
        this.domNotificationService = domNotificationService;
        this.domMountPointService = domMountPointService;
        this.lightyServerBuilder = serverBuilder;
        this.webSocketPort = new PortNumber(Uint16.valueOf((int)webSocketPort));
        this.jsonRestconfServiceType = jsonRestconfServiceType;
        this.domSchemaService = domSchemaService;
        this.httpPort = httpPort;
        this.inetAddress = inetAddress;
        this.restconfServletContextPath = restconfServletContextPath;
    }

    public CommunityRestConf(DOMDataBroker domDataBroker, DOMSchemaService schemaService, DOMRpcService domRpcService, DOMActionService domActionService, DOMNotificationService domNotificationService, DOMMountPointService domMountPointService, int webSocketPort, JsonRestConfServiceType jsonRestconfServiceType, DOMSchemaService domSchemaService, InetAddress inetAddress, int httpPort, String restconfServletContextPath, ExecutorService executorService) {
        this(domDataBroker, schemaService, domRpcService, domActionService, domNotificationService, domMountPointService, webSocketPort, jsonRestconfServiceType, domSchemaService, inetAddress, httpPort, restconfServletContextPath, executorService, null);
    }

    protected boolean initProcedure() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        LOG.info("Starting RestConfProvider websocket port: {}", (Object)this.webSocketPort);
        this.controllerContext = new ControllerContext(this.domSchemaService, this.domMountPointService, this.domSchemaService);
        this.brokerFacade = new BrokerFacade(this.domRpcService, this.domDataBroker, this.domNotificationService, this.controllerContext);
        this.restconfImpl = new RestconfImpl(this.brokerFacade, this.controllerContext);
        StatisticsRestconfServiceWrapper stats = new StatisticsRestconfServiceWrapper(this.restconfImpl);
        this.restconfProvider = new RestconfProviderImpl(stats, IpAddressBuilder.getDefaultInstance((String)this.inetAddress.getHostAddress()), this.webSocketPort);
        this.restconfProvider.start();
        LOG.info("Starting RestConnectorProvider");
        TransactionChainHandler transactionChainHandler = new TransactionChainHandler(this.domDataBroker);
        SchemaContextHandler schemaCtxHandler = new SchemaContextHandler(transactionChainHandler, this.domSchemaService);
        schemaCtxHandler.init();
        DOMMountPointServiceHandler domMountPointServiceHandler = new DOMMountPointServiceHandler(this.domMountPointService);
        DOMDataBrokerHandler domDataBrokerHandler = new DOMDataBrokerHandler(this.domDataBroker);
        RpcServiceHandler rpcServiceHandler = new RpcServiceHandler(this.domRpcService);
        ActionServiceHandler actionServiceHandler = new ActionServiceHandler(this.domActionService);
        NotificationServiceHandler notificationServiceHandler = new NotificationServiceHandler(this.domNotificationService);
        ServicesWrapper servicesWrapper = ServicesWrapper.newInstance((SchemaContextHandler)schemaCtxHandler, (DOMMountPointServiceHandler)domMountPointServiceHandler, (TransactionChainHandler)transactionChainHandler, (DOMDataBrokerHandler)domDataBrokerHandler, (RpcServiceHandler)rpcServiceHandler, (ActionServiceHandler)actionServiceHandler, (NotificationServiceHandler)notificationServiceHandler, (DOMSchemaService)this.domSchemaService);
        ServletHolder jaxrs = null;
        LOG.info("Starting jsonRestconfService {}", (Object)this.jsonRestconfServiceType.name());
        switch (this.jsonRestconfServiceType) {
            case DRAFT_02: {
                org.opendaylight.netconf.sal.rest.impl.RestconfApplication restconfApplication = new org.opendaylight.netconf.sal.rest.impl.RestconfApplication(this.controllerContext, stats);
                ServletContainer servletContainer = new ServletContainer(ResourceConfig.forApplication((Application)restconfApplication));
                jaxrs = new ServletHolder((Servlet)servletContainer);
                break;
            }
            case DRAFT_18: {
                RestconfApplication restconfApplication8040 = new RestconfApplication(schemaCtxHandler, domMountPointServiceHandler, servicesWrapper);
                ServletContainer servletContainer8040 = new ServletContainer(ResourceConfig.forApplication((Application)restconfApplication8040));
                jaxrs = new ServletHolder((Servlet)servletContainer8040);
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported restconf service type: " + this.jsonRestconfServiceType.name());
            }
        }
        LOG.info("RestConf init complete, starting Jetty");
        LOG.info("http address:port {}:{}, url prefix: {}", new Object[]{this.inetAddress.toString(), this.httpPort, this.restconfServletContextPath});
        try {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(this.inetAddress, this.httpPort);
            ContextHandlerCollection contexts = new ContextHandlerCollection();
            ServletContextHandler mainHandler = new ServletContextHandler((HandlerContainer)contexts, this.restconfServletContextPath, true, false);
            mainHandler.addServlet(jaxrs, "/*");
            boolean startDefault = false;
            if (this.lightyServerBuilder == null) {
                this.lightyServerBuilder = new LightyServerBuilder(inetSocketAddress);
                startDefault = true;
            }
            this.lightyServerBuilder.addContextHandler((Handler)contexts);
            if (startDefault) {
                this.startServer();
            }
        }
        catch (IllegalStateException e) {
            LOG.error("Failed to start jetty: ", (Throwable)e);
        }
        LOG.info("Lighty RestConf started in {}", (Object)stopwatch.stop());
        return true;
    }

    protected boolean stopProcedure() {
        boolean stopFailed = false;
        if (this.restconfProvider != null) {
            this.restconfProvider.close();
            LOG.info("RestconfProvider closed");
        }
        if (this.jettyServer != null) {
            try {
                this.jettyServer.stop();
                LOG.info("Jetty stopped");
            }
            catch (Exception e) {
                LOG.error("{} failed to stop!", this.jettyServer.getClass(), (Object)e);
                stopFailed = true;
            }
        }
        if (this.lightyServerBuilder != null) {
            this.lightyServerBuilder = null;
        }
        return !stopFailed;
    }

    public void startServer() {
        if (this.jettyServer != null && !this.jettyServer.isStopped()) {
            return;
        }
        try {
            this.jettyServer = this.lightyServerBuilder.build();
            this.jettyServer.start();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IllegalStateException("Failed to start jetty!", e);
        }
        LOG.info("Jetty started");
    }

    public RestconfImpl getRestconfImpl() {
        return this.restconfImpl;
    }

    public BrokerFacade getBrokerFacade() {
        return this.brokerFacade;
    }

    public ControllerContext getControllerContext() {
        return this.controllerContext;
    }
}

