/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.modules.northbound.restconf.community.impl.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import io.lighty.core.controller.api.LightyServices;
import io.lighty.core.controller.impl.config.ConfigurationException;
import io.lighty.modules.northbound.restconf.community.impl.config.RestConfConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.monitoring.rev170126.;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev170126.;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160621.;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RestConfConfigUtils {
    public static final String RESTCONF_CONFIG_ROOT_ELEMENT_NAME = "restconf";
    public static final Set<YangModuleInfo> YANG_MODELS = ImmutableSet.of((Object).YangModuleInfoImpl.getInstance(), (Object).YangModuleInfoImpl.getInstance(), (Object).YangModuleInfoImpl.getInstance());
    private static final Logger LOG = LoggerFactory.getLogger(RestConfConfigUtils.class);

    private RestConfConfigUtils() {
        throw new UnsupportedOperationException();
    }

    public static RestConfConfiguration getRestConfConfiguration(InputStream jsonConfigInputStream) throws ConfigurationException {
        JsonNode configNode;
        ObjectMapper mapper = new ObjectMapper();
        try {
            configNode = mapper.readTree(jsonConfigInputStream);
        }
        catch (IOException e) {
            throw new ConfigurationException("Cannot deserialize Json content to Json tree nodes", (Throwable)e);
        }
        if (!configNode.has(RESTCONF_CONFIG_ROOT_ELEMENT_NAME)) {
            LOG.warn("Json config does not contain {} element. Using defaults.", (Object)RESTCONF_CONFIG_ROOT_ELEMENT_NAME);
            return new RestConfConfiguration();
        }
        JsonNode restconfNode = configNode.path(RESTCONF_CONFIG_ROOT_ELEMENT_NAME);
        RestConfConfiguration restconfConfiguration = null;
        try {
            restconfConfiguration = (RestConfConfiguration)mapper.treeToValue((TreeNode)restconfNode, RestConfConfiguration.class);
        }
        catch (JsonProcessingException e) {
            throw new ConfigurationException(String.format("Cannot bind Json tree to type: %s", RestConfConfiguration.class), (Throwable)e);
        }
        return restconfConfiguration;
    }

    public static RestConfConfiguration getRestConfConfiguration(InputStream jsonConfigInputStream, LightyServices lightyServices) throws ConfigurationException {
        JsonNode configNode;
        ObjectMapper mapper = new ObjectMapper();
        try {
            configNode = mapper.readTree(jsonConfigInputStream);
        }
        catch (IOException e) {
            throw new ConfigurationException("Cannot deserialize Json content to Json tree nodes", (Throwable)e);
        }
        if (!configNode.has(RESTCONF_CONFIG_ROOT_ELEMENT_NAME)) {
            LOG.warn("Json config does not contain {} element. Using defaults.", (Object)RESTCONF_CONFIG_ROOT_ELEMENT_NAME);
            return RestConfConfigUtils.getDefaultRestConfConfiguration(lightyServices);
        }
        JsonNode restconfNode = configNode.path(RESTCONF_CONFIG_ROOT_ELEMENT_NAME);
        RestConfConfiguration restconfConfiguration = null;
        try {
            restconfConfiguration = (RestConfConfiguration)mapper.treeToValue((TreeNode)restconfNode, RestConfConfiguration.class);
        }
        catch (JsonProcessingException e) {
            throw new ConfigurationException(String.format("Cannot bind Json tree to type: %s", RestConfConfiguration.class), (Throwable)e);
        }
        restconfConfiguration.setDomDataBroker(lightyServices.getClusteredDOMDataBroker());
        restconfConfiguration.setSchemaService(lightyServices.getDOMSchemaService());
        restconfConfiguration.setDomRpcService(lightyServices.getDOMRpcService());
        restconfConfiguration.setDomNotificationService(lightyServices.getDOMNotificationService());
        restconfConfiguration.setDomMountPointService(lightyServices.getDOMMountPointService());
        restconfConfiguration.setDomSchemaService(lightyServices.getDOMSchemaService());
        return restconfConfiguration;
    }

    public static RestConfConfiguration getRestConfConfiguration(RestConfConfiguration restConfConfiguration, LightyServices lightyServices) {
        RestConfConfiguration config = new RestConfConfiguration(restConfConfiguration);
        config.setDomDataBroker(lightyServices.getClusteredDOMDataBroker());
        config.setSchemaService(lightyServices.getDOMSchemaService());
        config.setDomRpcService(lightyServices.getDOMRpcService());
        config.setDomActionService(lightyServices.getDOMActionService());
        config.setDomNotificationService(lightyServices.getDOMNotificationService());
        config.setDomMountPointService(lightyServices.getDOMMountPointService());
        config.setDomSchemaService(lightyServices.getDOMSchemaService());
        return config;
    }

    public static RestConfConfiguration getDefaultRestConfConfiguration(LightyServices lightyServices) {
        return new RestConfConfiguration(lightyServices.getClusteredDOMDataBroker(), lightyServices.getDOMSchemaService(), lightyServices.getDOMRpcService(), lightyServices.getDOMActionService(), lightyServices.getDOMNotificationService(), lightyServices.getDOMMountPointService(), lightyServices.getDOMSchemaService());
    }

    public static RestConfConfiguration getDefaultRestConfConfiguration() {
        return new RestConfConfiguration();
    }
}

