/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.modules.southbound.ovsdb;

import io.lighty.core.controller.api.AbstractLightyModule;
import io.lighty.core.controller.api.LightyServices;
import org.opendaylight.ovsdb.lib.OvsdbConnection;
import org.opendaylight.ovsdb.lib.impl.OvsdbConnectionService;
import org.opendaylight.ovsdb.southbound.SouthboundProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OvsdbSouthboundPlugin
extends AbstractLightyModule {
    private static final Logger LOG = LoggerFactory.getLogger(OvsdbSouthboundPlugin.class);
    private final LightyServices lightyServices;
    private SouthboundProvider southboundProvider;

    public OvsdbSouthboundPlugin(LightyServices lightyServices) {
        this.lightyServices = lightyServices;
    }

    protected boolean initProcedure() {
        LOG.info("Initializing ovsdb southbound plugin");
        this.southboundProvider = new SouthboundProvider(this.lightyServices.getControllerBindingDataBroker(), this.lightyServices.getEntityOwnershipService(), (OvsdbConnection)new OvsdbConnectionService(), this.lightyServices.getDOMSchemaService(), this.lightyServices.getBindingNormalizedNodeSerializer(), this.lightyServices.getSystemReadyMonitor(), this.lightyServices.getDiagStatusService());
        this.southboundProvider.init();
        return true;
    }

    protected boolean stopProcedure() {
        try {
            if (this.southboundProvider != null) {
                this.southboundProvider.close();
            }
            return true;
        }
        catch (Exception e) {
            LOG.error("Stop procedure failed!", (Throwable)e);
            return false;
        }
    }
}

