/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.modules.southbound.openflow.impl;

import io.lighty.core.controller.api.AbstractLightyModule;
import io.lighty.core.controller.api.LightyServices;
import io.lighty.modules.southbound.openflow.impl.config.ConfigurationServiceFactory;
import io.lighty.modules.southbound.openflow.impl.config.OpenflowpluginConfiguration;
import io.lighty.modules.southbound.openflow.impl.util.OpenflowConfigUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.mdsal.binding.api.RpcConsumerRegistry;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMRpcServiceAdapter;
import org.opendaylight.openflowjava.protocol.api.connection.OpenflowDiagStatusProvider;
import org.opendaylight.openflowjava.protocol.impl.core.DefaultOpenflowDiagStatusProvider;
import org.opendaylight.openflowjava.protocol.spi.connection.SwitchConnectionProvider;
import org.opendaylight.openflowjava.protocol.spi.connection.SwitchConnectionProviderList;
import org.opendaylight.openflowplugin.api.openflow.FlowGroupCacheManager;
import org.opendaylight.openflowplugin.api.openflow.OpenFlowPluginProvider;
import org.opendaylight.openflowplugin.api.openflow.configuration.ConfigurationService;
import org.opendaylight.openflowplugin.api.openflow.mastership.MastershipChangeException;
import org.opendaylight.openflowplugin.api.openflow.mastership.MastershipChangeServiceManager;
import org.opendaylight.openflowplugin.applications.arbitratorreconciliation.impl.ArbitratorReconciliationManagerImpl;
import org.opendaylight.openflowplugin.applications.frm.impl.ForwardingRulesManagerImpl;
import org.opendaylight.openflowplugin.applications.frm.impl.ListenerRegistrationHelper;
import org.opendaylight.openflowplugin.applications.frm.recovery.OpenflowServiceRecoveryHandler;
import org.opendaylight.openflowplugin.applications.frm.recovery.impl.OpenflowServiceRecoveryHandlerImpl;
import org.opendaylight.openflowplugin.applications.reconciliation.ReconciliationManager;
import org.opendaylight.openflowplugin.applications.reconciliation.impl.ReconciliationManagerImpl;
import org.opendaylight.openflowplugin.applications.topology.manager.FlowCapableTopologyProvider;
import org.opendaylight.openflowplugin.applications.topology.manager.NodeChangeListenerImpl;
import org.opendaylight.openflowplugin.applications.topology.manager.OperationProcessor;
import org.opendaylight.openflowplugin.applications.topology.manager.TerminationPointChangeListenerImpl;
import org.opendaylight.openflowplugin.impl.ForwardingPingPongDataBroker;
import org.opendaylight.openflowplugin.impl.OpenFlowPluginProviderImpl;
import org.opendaylight.openflowplugin.impl.PingPongDataBroker;
import org.opendaylight.openflowplugin.impl.mastership.MastershipChangeServiceManagerImpl;
import org.opendaylight.openflowplugin.impl.services.cache.FlowGroupCacheManagerImpl;
import org.opendaylight.serviceutils.srm.ServiceRecoveryRegistry;
import org.opendaylight.serviceutils.srm.impl.ServiceRecoveryRegistryImpl;
import org.opendaylight.serviceutils.upgrade.UpgradeState;
import org.opendaylight.serviceutils.upgrade.impl.UpgradeStateListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.PacketProcessingListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow.provider.config.rev160510.OpenflowProviderConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.app.arbitrator.reconcile.service.rev180227.ArbitratorReconcileService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.app.forwardingrules.manager.config.rev160511.ForwardingRulesManagerConfigBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.upgrade.rev180702.UpgradeConfigBuilder;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.NotificationListener;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenflowSouthboundPlugin
extends AbstractLightyModule {
    private static final Logger LOG = LoggerFactory.getLogger(OpenflowSouthboundPlugin.class);
    private final ConfigurationService configurationService;
    private final LightyServices lightyServices;
    private OpenFlowPluginProvider openFlowPluginProvider;
    private final List<SwitchConnectionProvider> providers;
    private ListenerRegistrationHelper listenerRegistrationHelper;
    private ForwardingRulesManagerImpl forwardingRulesManagerImpl;
    private OpenflowServiceRecoveryHandlerImpl openflowServiceRecoveryHandlerImpl;
    private ForwardingRulesManagerConfigBuilder frmConfigBuilder;
    private ArbitratorReconciliationManagerImpl arbitratorReconciliationManager;
    private PacketProcessingListener packetProcessingListener;
    private ListenerRegistration<NotificationListener> packetListenerNotificationRegistration;
    private OperationProcessor operationProcessor;
    private FlowCapableTopologyProvider flowCapableTopologyProvider;
    private MastershipChangeServiceManagerImpl mastershipChangeServiceManager;
    private TerminationPointChangeListenerImpl terminationPointChangeListener;
    private NodeChangeListenerImpl nodeChangeListener;

    public OpenflowSouthboundPlugin(LightyServices lightyServices, ExecutorService executorService) {
        super(executorService);
        OpenflowpluginConfiguration defaultOfpConfiguration = OpenflowConfigUtils.getDefaultOfpConfiguration();
        this.lightyServices = lightyServices;
        this.providers = Objects.requireNonNull(defaultOfpConfiguration).getSwitchConfig().getDefaultProviders(lightyServices.getDiagStatusService());
        this.configurationService = new ConfigurationServiceFactory().newInstance(defaultOfpConfiguration.getDefaultProviderConfig());
    }

    public OpenflowSouthboundPlugin(@Nonnull LightyServices lightyServices, @Nonnull OpenflowProviderConfig openflowProviderConfig, @Nonnull List<SwitchConnectionProvider> providers, @Nullable ExecutorService executorService, @Nullable ForwardingRulesManagerConfigBuilder frmConfigBuilder, @Nullable PacketProcessingListener packetProcessingListener) {
        super(executorService);
        this.lightyServices = lightyServices;
        this.providers = providers;
        this.configurationService = new ConfigurationServiceFactory().newInstance(openflowProviderConfig);
        this.frmConfigBuilder = frmConfigBuilder;
        this.packetProcessingListener = packetProcessingListener;
    }

    protected boolean initProcedure() {
        ForwardingPingPongDataBroker forwardingPingPongDataBroker = new ForwardingPingPongDataBroker(this.lightyServices.getBindingDataBroker());
        SwitchConnectionProviderList switchConnectionProviders = new SwitchConnectionProviderList(this.providers);
        if (this.openFlowPluginProvider == null) {
            this.mastershipChangeServiceManager = new MastershipChangeServiceManagerImpl();
            DefaultOpenflowDiagStatusProvider diagStat = new DefaultOpenflowDiagStatusProvider(this.lightyServices.getDiagStatusService());
            this.openFlowPluginProvider = new OpenFlowPluginProviderImpl(this.configurationService, switchConnectionProviders, (PingPongDataBroker)forwardingPingPongDataBroker, this.lightyServices.getRpcProviderService(), this.lightyServices.getBindingNotificationPublishService(), this.lightyServices.getClusterSingletonServiceProvider(), this.lightyServices.getEntityOwnershipService(), (MastershipChangeServiceManager)this.mastershipChangeServiceManager, (OpenflowDiagStatusProvider)diagStat, this.lightyServices.getSystemReadyMonitor());
            this.openFlowPluginProvider.initialize();
            if (this.frmConfigBuilder != null) {
                ReconciliationManagerImpl reconciliationManagerImpl = new ReconciliationManagerImpl((MastershipChangeServiceManager)this.mastershipChangeServiceManager);
                UpgradeStateListener upgradeStateListener = new UpgradeStateListener(this.lightyServices.getBindingDataBroker(), new UpgradeConfigBuilder().build());
                try {
                    reconciliationManagerImpl.start();
                }
                catch (MastershipChangeException e) {
                    LOG.error("Failed registration ReconciliationManagerImpl", (Throwable)e);
                }
                BindingDOMRpcServiceAdapter rpcConsumerRegistry = new BindingDOMRpcServiceAdapter(this.lightyServices.getAdapterContext(), this.lightyServices.getDOMRpcService());
                this.arbitratorReconciliationManager = new ArbitratorReconciliationManagerImpl((ReconciliationManager)reconciliationManagerImpl, this.lightyServices.getRpcProviderService(), (RpcConsumerRegistry)rpcConsumerRegistry, (UpgradeState)upgradeStateListener);
                this.arbitratorReconciliationManager.start();
                this.lightyServices.getRpcProviderService().registerRpcImplementation(ArbitratorReconcileService.class, (RpcService)this.arbitratorReconciliationManager);
                ServiceRecoveryRegistryImpl serviceRecoveryRegistryImpl = new ServiceRecoveryRegistryImpl();
                this.openflowServiceRecoveryHandlerImpl = new OpenflowServiceRecoveryHandlerImpl((ServiceRecoveryRegistry)serviceRecoveryRegistryImpl);
                this.listenerRegistrationHelper = new ListenerRegistrationHelper(this.lightyServices.getBindingDataBroker());
                this.forwardingRulesManagerImpl = new ForwardingRulesManagerImpl(this.lightyServices.getBindingDataBroker(), (RpcConsumerRegistry)rpcConsumerRegistry, this.lightyServices.getRpcProviderService(), this.frmConfigBuilder.build(), (MastershipChangeServiceManager)this.mastershipChangeServiceManager, this.lightyServices.getClusterSingletonServiceProvider(), this.configurationService, (ReconciliationManager)reconciliationManagerImpl, (OpenflowServiceRecoveryHandler)this.openflowServiceRecoveryHandlerImpl, (ServiceRecoveryRegistry)serviceRecoveryRegistryImpl, (FlowGroupCacheManager)new FlowGroupCacheManagerImpl(), this.listenerRegistrationHelper);
                this.forwardingRulesManagerImpl.start();
                LOG.info("OFP started with FRM & ARM");
            } else {
                LOG.info("FRM already initialized !");
            }
            this.operationProcessor = new OperationProcessor(this.lightyServices.getBindingDataBroker());
            this.operationProcessor.start();
            this.terminationPointChangeListener = new TerminationPointChangeListenerImpl(this.lightyServices.getBindingDataBroker(), this.operationProcessor);
            this.nodeChangeListener = new NodeChangeListenerImpl(this.lightyServices.getBindingDataBroker(), this.operationProcessor);
            this.flowCapableTopologyProvider = new FlowCapableTopologyProvider(this.lightyServices.getBindingDataBroker(), this.lightyServices.getNotificationService(), this.operationProcessor, this.lightyServices.getClusterSingletonServiceProvider());
            this.flowCapableTopologyProvider.start();
            if (this.packetProcessingListener != null) {
                this.packetListenerNotificationRegistration = this.lightyServices.getNotificationService().registerNotificationListener((NotificationListener)this.packetProcessingListener);
                LOG.info("OfpPacketListener Started.");
            } else {
                LOG.info("OfpPacketListener is null, skipping registration !");
            }
            return true;
        }
        LOG.warn("Openflow-plugin provider is not null. Instance is already running.");
        return false;
    }

    protected boolean stopProcedure() {
        ArrayList<Boolean> destroyResult = new ArrayList<Boolean>();
        destroyResult.add(this.destroy((AutoCloseable)this.packetListenerNotificationRegistration));
        destroyResult.add(this.destroy((AutoCloseable)this.flowCapableTopologyProvider));
        destroyResult.add(this.destroy((AutoCloseable)this.operationProcessor));
        destroyResult.add(this.destroy((AutoCloseable)this.forwardingRulesManagerImpl));
        if (this.listenerRegistrationHelper != null) {
            try {
                this.listenerRegistrationHelper.close();
                destroyResult.add(true);
            }
            catch (Exception e) {
                LOG.warn("Exception was thrown during closing listenerRegistrationHelper", (Throwable)e);
                destroyResult.add(false);
            }
        }
        destroyResult.add(this.destroy((AutoCloseable)this.arbitratorReconciliationManager));
        destroyResult.add(this.destroy((AutoCloseable)this.openFlowPluginProvider));
        destroyResult.add(this.destroy((AutoCloseable)this.mastershipChangeServiceManager));
        destroyResult.add(this.destroy((AutoCloseable)this.terminationPointChangeListener));
        destroyResult.add(this.destroy((AutoCloseable)this.nodeChangeListener));
        return !destroyResult.contains(false);
    }

    private boolean destroy(AutoCloseable instance) {
        if (instance != null) {
            try {
                instance.close();
            }
            catch (Exception e) {
                LOG.warn("Exception was thrown during closing {}", (Object)instance.getClass().getSimpleName(), (Object)e);
                return false;
            }
        }
        return true;
    }
}

