/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.modules.southbound.openflow.impl.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import io.lighty.core.controller.impl.config.ConfigurationException;
import io.lighty.modules.southbound.openflow.impl.config.OpenflowpluginConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.arbitrary.bitmask.fields.rev160130.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.async.config.service.rev170619.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.direct.statistics.rev160511.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.echo.service.rev150305.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.experimenter.message.service.rev151020.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.experimenter.mp.message.service.rev151020.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flat.batch.service.rev160321.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.errors.rev131116.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.topology.discovery.rev130819.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flows.service.rev160314.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groups.service.rev160315.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meters.service.rev160316.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.statistics.types.rev130925.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.topology.inventory.rev131030.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.module.config.rev141015.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.multipart.types.rev170112.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.node.error.service.rev140410.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.opendaylight.ipv6.arbitrary.bitmask.fields.rev160224.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.approved.extensions.rev160802.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.config.rev140630.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.system.rev130927.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.experimenter.types.rev151020.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.general.rev140714.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.onf.bundle.service.rev170124.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.onf.rev170124.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.core.general.entity.rev150930.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow.provider.config.rev160510.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.app.arbitrator.reconcile.service.rev180227.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.app.frm.reconciliation.service.rev180227.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.rf.state.rev170713.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.sm.control.rev150812.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.service.rev131107.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.service.rev150305.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.role.service.rev150727.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.service.barrier.common.rev160315.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.service.batch.common.rev160322.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.upgrade.rev180702.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.service.rev131026.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpenflowConfigUtils {
    private static final Logger LOG = LoggerFactory.getLogger(OpenflowConfigUtils.class);
    private static final String OFP_CONFIG_ROOT_ELEMENT_NAME = "openflow";
    public static final Set<YangModuleInfo> OFP_MODELS = ImmutableSet.of((Object).YangModuleInfoImpl.getInstance(), (Object).YangModuleInfoImpl.getInstance(), (Object).YangModuleInfoImpl.getInstance(), (Object).YangModuleInfoImpl.getInstance(), (Object).YangModuleInfoImpl.getInstance(), (Object).YangModuleInfoImpl.getInstance(), (Object[])new YangModuleInfo[]{.YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance()});

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static OpenflowpluginConfiguration getDefaultOfpConfiguration() {
        try (InputStream inputStream = OpenflowConfigUtils.class.getClassLoader().getResourceAsStream("defaultOfpConfig.json");){
            OpenflowpluginConfiguration openflowpluginConfiguration = OpenflowConfigUtils.getOfpConfiguration(inputStream);
            return openflowpluginConfiguration;
        }
        catch (ConfigurationException | IOException e) {
            LOG.error("Failed to load  default configuration for Openflow plugin!", e);
            return null;
        }
    }

    public static OpenflowpluginConfiguration getOfpConfiguration(InputStream jsonConfigInputStream) throws ConfigurationException {
        JsonNode configNode;
        ObjectMapper mapper = new ObjectMapper();
        try {
            configNode = mapper.readTree(jsonConfigInputStream);
        }
        catch (IOException e) {
            throw new ConfigurationException("Cannot deserialize Json content to Json tree nodes", (Throwable)e);
        }
        if (!configNode.has(OFP_CONFIG_ROOT_ELEMENT_NAME)) {
            LOG.warn("Json config does not contain {} element. Using defaults.", (Object)OFP_CONFIG_ROOT_ELEMENT_NAME);
            return OpenflowConfigUtils.getDefaultOfpConfiguration();
        }
        JsonNode ofpNode = configNode.path(OFP_CONFIG_ROOT_ELEMENT_NAME);
        try {
            return (OpenflowpluginConfiguration)mapper.treeToValue((TreeNode)ofpNode, OpenflowpluginConfiguration.class);
        }
        catch (JsonProcessingException e) {
            throw new ConfigurationException(String.format("Cannot bind Json tree to type: %s", OpenflowpluginConfiguration.class), (Throwable)e);
        }
    }
}

