/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.modules.southbound.openflow.impl.config;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opendaylight.openflowplugin.api.openflow.configuration.ConfigurationListener;
import org.opendaylight.openflowplugin.api.openflow.configuration.ConfigurationProperty;
import org.opendaylight.openflowplugin.api.openflow.configuration.ConfigurationService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow.provider.config.rev160510.OpenflowProviderConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationServiceFactory.class);

    public ConfigurationService newInstance(OpenflowProviderConfig providerConfig) {
        return new ConfigurationServiceImpl(providerConfig);
    }

    private static final class ConfigurationServiceImpl
    implements ConfigurationService {
        private final Map<String, String> propertyMap = new HashMap<String, String>();
        private final List<ConfigurationListener> listeners = new ArrayList<ConfigurationListener>();

        ConfigurationServiceImpl(OpenflowProviderConfig providerConfig) {
            this.update((Map<String, String>)ImmutableMap.builder().put((Object)ConfigurationProperty.RPC_REQUESTS_QUOTA.toString(), (Object)providerConfig.getRpcRequestsQuota().getValue().toString()).put((Object)ConfigurationProperty.GLOBAL_NOTIFICATION_QUOTA.toString(), (Object)providerConfig.getGlobalNotificationQuota().toString()).put((Object)ConfigurationProperty.SWITCH_FEATURES_MANDATORY.toString(), (Object)providerConfig.isSwitchFeaturesMandatory().toString()).put((Object)ConfigurationProperty.ENABLE_FLOW_REMOVED_NOTIFICATION.toString(), (Object)providerConfig.isEnableFlowRemovedNotification().toString()).put((Object)ConfigurationProperty.IS_STATISTICS_RPC_ENABLED.toString(), (Object)providerConfig.isIsStatisticsRpcEnabled().toString()).put((Object)ConfigurationProperty.BARRIER_COUNT_LIMIT.toString(), (Object)providerConfig.getBarrierCountLimit().getValue().toString()).put((Object)ConfigurationProperty.BARRIER_INTERVAL_TIMEOUT_LIMIT.toString(), (Object)providerConfig.getBarrierIntervalTimeoutLimit().getValue().toString()).put((Object)ConfigurationProperty.ECHO_REPLY_TIMEOUT.toString(), (Object)providerConfig.getEchoReplyTimeout().getValue().toString()).put((Object)ConfigurationProperty.IS_STATISTICS_POLLING_ON.toString(), (Object)providerConfig.isIsStatisticsPollingOn().toString()).put((Object)ConfigurationProperty.SKIP_TABLE_FEATURES.toString(), (Object)providerConfig.isSkipTableFeatures().toString()).put((Object)ConfigurationProperty.BASIC_TIMER_DELAY.toString(), (Object)providerConfig.getBasicTimerDelay().getValue().toString()).put((Object)ConfigurationProperty.MAXIMUM_TIMER_DELAY.toString(), (Object)providerConfig.getMaximumTimerDelay().getValue().toString()).put((Object)ConfigurationProperty.USE_SINGLE_LAYER_SERIALIZATION.toString(), (Object)providerConfig.isUseSingleLayerSerialization().toString()).put((Object)ConfigurationProperty.THREAD_POOL_MIN_THREADS.toString(), (Object)providerConfig.getThreadPoolMinThreads().toString()).put((Object)ConfigurationProperty.THREAD_POOL_MAX_THREADS.toString(), (Object)providerConfig.getThreadPoolMaxThreads().getValue().toString()).put((Object)ConfigurationProperty.THREAD_POOL_TIMEOUT.toString(), (Object)providerConfig.getThreadPoolTimeout().toString()).put((Object)ConfigurationProperty.IS_FLOW_STATISTICS_POLLING_ON.toString(), (Object)providerConfig.isIsFlowStatisticsPollingOn().toString()).put((Object)ConfigurationProperty.IS_QUEUE_STATISTICS_POLLING_ON.toString(), (Object)providerConfig.isIsQueueStatisticsPollingOn().toString()).put((Object)ConfigurationProperty.IS_TABLE_STATISTICS_POLLING_ON.toString(), (Object)providerConfig.isIsTableStatisticsPollingOn().toString()).put((Object)ConfigurationProperty.IS_GROUP_STATISTICS_POLLING_ON.toString(), (Object)providerConfig.isIsGroupStatisticsPollingOn().toString()).put((Object)ConfigurationProperty.IS_PORT_STATISTICS_POLLING_ON.toString(), (Object)providerConfig.isIsPortStatisticsPollingOn().toString()).put((Object)ConfigurationProperty.IS_METER_STATISTICS_POLLING_ON.toString(), (Object)providerConfig.isIsMeterStatisticsPollingOn().toString()).put((Object)ConfigurationProperty.DEVICE_CONNECTION_RATE_LIMIT_PER_MIN.toString(), (Object)providerConfig.getDeviceConnectionRateLimitPerMin().toString()).build());
        }

        public void update(@Nonnull Map<String, String> properties) {
            properties.forEach((propertyName, newValue) -> {
                String originalValue = this.propertyMap.get(propertyName);
                if (Objects.nonNull(originalValue)) {
                    if (originalValue.equals(newValue)) {
                        return;
                    }
                    LOG.info("{} configuration property was changed from '{}' to '{}'", new Object[]{propertyName, originalValue, newValue});
                } else {
                    if (Objects.isNull(newValue)) {
                        return;
                    }
                    LOG.info("{} configuration property was changed to '{}'", propertyName, newValue);
                }
                this.propertyMap.put((String)propertyName, (String)newValue);
                this.listeners.forEach(listener -> listener.onPropertyChanged(propertyName, newValue));
            });
        }

        @Nonnull
        public <T> T getProperty(@Nonnull String key, @Nonnull Function<String, T> transformer) {
            return transformer.apply(this.propertyMap.get(key));
        }

        @Nonnull
        public AutoCloseable registerListener(@Nonnull ConfigurationListener listener) {
            Verify.verify((!this.listeners.contains(listener) ? 1 : 0) != 0);
            LOG.info("{} was registered as configuration listener to OpenFlowPlugin configuration service", (Object)listener);
            this.listeners.add(listener);
            this.propertyMap.forEach((arg_0, arg_1) -> ((ConfigurationListener)listener).onPropertyChanged(arg_0, arg_1));
            return () -> this.listeners.remove(listener);
        }

        public void close() throws Exception {
            this.propertyMap.clear();
            this.listeners.clear();
        }
    }
}

