/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.modules.southbound.openflow.impl;

import io.lighty.core.controller.api.LightyServices;
import io.lighty.modules.southbound.openflow.impl.OpenflowSouthboundPlugin;
import io.lighty.modules.southbound.openflow.impl.config.OpenflowpluginConfiguration;
import io.lighty.modules.southbound.openflow.impl.config.SwitchConfig;
import java.util.concurrent.ExecutorService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.PacketProcessingListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.app.forwardingrules.manager.config.rev160511.ForwardingRulesManagerConfigBuilder;

public class OpenflowSouthboundPluginBuilder {
    private LightyServices lightyServices;
    private OpenflowpluginConfiguration ofpConfiguration;
    private SwitchConfig switchConnectionProviders;
    private ExecutorService executorService = null;
    private PacketProcessingListener ofpPacketListener;
    private ForwardingRulesManagerConfigBuilder forwardingRulesManagerConfigBuilder;

    public OpenflowSouthboundPluginBuilder from(OpenflowpluginConfiguration openflowpluginConfiguration, LightyServices lightyServices) {
        this.ofpConfiguration = openflowpluginConfiguration;
        this.switchConnectionProviders = openflowpluginConfiguration.getSwitchConfig();
        this.lightyServices = lightyServices;
        return this;
    }

    public OpenflowSouthboundPluginBuilder withExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public OpenflowSouthboundPluginBuilder withPacketListener(PacketProcessingListener ofpPacketListener) {
        this.ofpPacketListener = ofpPacketListener;
        return this;
    }

    public OpenflowSouthboundPlugin build() {
        if (this.ofpConfiguration.isEnableForwardingRulesManager()) {
            this.forwardingRulesManagerConfigBuilder = this.ofpConfiguration.getFrmConfigBuilder();
        }
        return new OpenflowSouthboundPlugin(this.lightyServices, this.ofpConfiguration.getOpenflowProviderConfig(), this.switchConnectionProviders.getProviders(this.lightyServices.getDiagStatusService(), this.ofpConfiguration.getOpenflowProviderConfig(), this.executorService), this.executorService, this.forwardingRulesManagerConfigBuilder, this.ofpPacketListener);
    }
}

