/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.modules.southbound.openflow.impl.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.opendaylight.infrautils.diagstatus.DiagStatusService;
import org.opendaylight.openflowjava.protocol.impl.core.SwitchConnectionProviderFactoryImpl;
import org.opendaylight.openflowjava.protocol.spi.connection.SwitchConnectionProvider;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.config.rev140630.KeystoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.config.rev140630.PathType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.config.rev140630.TransportProtocol;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506.SwitchConnectionConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506.SwitchConnectionConfigBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506._switch.connection.config.TlsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow.provider.config.rev160510.OpenflowProviderConfig;

public class SwitchConfig {
    @JsonIgnore
    private final SwitchConnectionConfig defaultSwitch;
    @JsonIgnore
    private final SwitchConnectionConfig legacySwitch;
    @JsonIgnore
    private final String legacyInstanceName = "openflow-switch-connection-provider-legacy-impl";
    @JsonIgnore
    private final int legacyPort = 6633;
    private String instanceName = "openflow-switch-connection-provider-default-impl";
    private int port = 6653;
    private int transportProtocol = TransportProtocol.TCP.getIntValue();
    private String address = null;
    private boolean useBarrier = true;
    private Long switchIdleTimeout = 15000L;
    private String keystore = "configuration/ssl/ctl.jks";
    private int keystoreType = KeystoreType.JKS.getIntValue();
    private int keystorePathType = PathType.PATH.getIntValue();
    private String keystorePassword = "opendaylight";
    private String truststore = "configuration/ssl/truststore.jks";
    private int truststoreType = KeystoreType.JKS.getIntValue();
    private int truststorePathType = PathType.PATH.getIntValue();
    private String truststorePassword = "opendaylight";
    private String certificatePassword = "opendaylight";
    private int channelOutboundQueueSize = 1024;

    public SwitchConfig() {
        this.defaultSwitch = new SwitchConnectionConfigBuilder().setInstanceName(this.instanceName).setPort(Integer.valueOf(this.port)).setTransportProtocol(TransportProtocol.forValue((int)this.transportProtocol)).setSwitchIdleTimeout(this.switchIdleTimeout).setUseBarrier(Boolean.valueOf(this.useBarrier)).setChannelOutboundQueueSize(Integer.valueOf(this.channelOutboundQueueSize)).setTls(new TlsBuilder().setKeystore(this.keystore).setKeystoreType(KeystoreType.forValue((int)this.keystoreType)).setKeystorePathType(PathType.forValue((int)this.keystorePathType)).setKeystorePassword(this.keystorePassword).setTruststore(this.truststore).setTruststoreType(KeystoreType.forValue((int)this.truststoreType)).setTruststorePathType(PathType.forValue((int)this.truststorePathType)).setTruststorePassword(this.truststorePassword).setCertificatePassword(this.certificatePassword).build()).build();
        this.legacySwitch = new SwitchConnectionConfigBuilder().setInstanceName(this.legacyInstanceName).setPort(Integer.valueOf(this.legacyPort)).setTransportProtocol(TransportProtocol.forValue((int)this.transportProtocol)).setSwitchIdleTimeout(this.switchIdleTimeout).setUseBarrier(Boolean.valueOf(this.useBarrier)).setChannelOutboundQueueSize(Integer.valueOf(this.channelOutboundQueueSize)).setTls(new TlsBuilder().setKeystore(this.keystore).setKeystoreType(KeystoreType.forValue((int)this.keystoreType)).setKeystorePathType(PathType.forValue((int)this.keystorePathType)).setKeystorePassword(this.keystorePassword).setTruststore(this.truststore).setTruststoreType(KeystoreType.forValue((int)this.truststoreType)).setTruststorePathType(PathType.forValue((int)this.truststorePathType)).setTruststorePassword(this.truststorePassword).setCertificatePassword(this.certificatePassword).build()).build();
    }

    public List<SwitchConnectionProvider> getDefaultProviders(DiagStatusService diagStatusService) {
        ArrayList<SwitchConnectionProvider> switchConnectionProviderList = new ArrayList<SwitchConnectionProvider>();
        switchConnectionProviderList.add(new SwitchConnectionProviderFactoryImpl(diagStatusService).newInstance(this.defaultSwitch));
        switchConnectionProviderList.add(new SwitchConnectionProviderFactoryImpl(diagStatusService).newInstance(this.legacySwitch));
        return switchConnectionProviderList;
    }

    public List<SwitchConnectionProvider> getProviders(DiagStatusService diagStatusService, OpenflowProviderConfig config, ExecutorService executorService) {
        SwitchConnectionConfig tmpDefaultSwitch = new SwitchConnectionConfigBuilder().setInstanceName(this.instanceName).setPort(Integer.valueOf(this.port)).setTransportProtocol(TransportProtocol.forValue((int)this.transportProtocol)).setSwitchIdleTimeout(this.switchIdleTimeout).setUseBarrier(Boolean.valueOf(this.useBarrier)).setChannelOutboundQueueSize(Integer.valueOf(this.channelOutboundQueueSize)).setTls(new TlsBuilder().setKeystore(this.keystore).setKeystoreType(KeystoreType.forValue((int)this.keystoreType)).setKeystorePathType(PathType.forValue((int)this.keystorePathType)).setKeystorePassword(this.keystorePassword).setTruststore(this.truststore).setTruststoreType(KeystoreType.forValue((int)this.truststoreType)).setTruststorePathType(PathType.forValue((int)this.truststorePathType)).setTruststorePassword(this.truststorePassword).setCertificatePassword(this.certificatePassword).build()).setGroupAddModEnabled(Boolean.valueOf(true)).build();
        SwitchConnectionConfig tmpLegacySwitch = new SwitchConnectionConfigBuilder().setInstanceName(this.legacyInstanceName).setPort(Integer.valueOf(this.legacyPort)).setTransportProtocol(TransportProtocol.forValue((int)this.transportProtocol)).setSwitchIdleTimeout(this.switchIdleTimeout).setUseBarrier(Boolean.valueOf(this.useBarrier)).setChannelOutboundQueueSize(Integer.valueOf(this.channelOutboundQueueSize)).setTls(new TlsBuilder().setKeystore(this.keystore).setKeystoreType(KeystoreType.forValue((int)this.keystoreType)).setKeystorePathType(PathType.forValue((int)this.keystorePathType)).setKeystorePassword(this.keystorePassword).setTruststore(this.truststore).setTruststoreType(KeystoreType.forValue((int)this.truststoreType)).setTruststorePathType(PathType.forValue((int)this.truststorePathType)).setTruststorePassword(this.truststorePassword).setCertificatePassword(this.certificatePassword).build()).setGroupAddModEnabled(Boolean.valueOf(true)).build();
        ArrayList<SwitchConnectionProvider> switchConnectionProviderList = new ArrayList<SwitchConnectionProvider>();
        SwitchConnectionProvider defaultSwitchConnectionProvider = new SwitchConnectionProviderFactoryImpl(diagStatusService).newInstance(tmpDefaultSwitch);
        switchConnectionProviderList.add(defaultSwitchConnectionProvider);
        SwitchConnectionProvider legacySwitchConnectionProvider = new SwitchConnectionProviderFactoryImpl(diagStatusService).newInstance(tmpLegacySwitch);
        switchConnectionProviderList.add(legacySwitchConnectionProvider);
        return switchConnectionProviderList;
    }

    public int getChannelOutboundQueueSize() {
        return this.channelOutboundQueueSize;
    }

    public void setChannelOutboundQueueSize(int channelOutboundQueueSize) {
        this.channelOutboundQueueSize = channelOutboundQueueSize;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getTransportProtocol() {
        return this.transportProtocol;
    }

    public void setTransportProtocol(int transportProtocol) {
        this.transportProtocol = transportProtocol;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public boolean isUseBarrier() {
        return this.useBarrier;
    }

    public void setUseBarrier(boolean useBarrier) {
        this.useBarrier = useBarrier;
    }

    public Long getSwitchIdleTimeout() {
        return this.switchIdleTimeout;
    }

    public void setSwitchIdleTimeout(Long switchIdleTimeout) {
        this.switchIdleTimeout = switchIdleTimeout;
    }

    public String getKeystore() {
        return this.keystore;
    }

    public void setKeystore(String keystore) {
        this.keystore = keystore;
    }

    public int getKeystoreType() {
        return this.keystoreType;
    }

    public void setKeystoreType(int keystoreType) {
        this.keystoreType = keystoreType;
    }

    public int getKeystorePathType() {
        return this.keystorePathType;
    }

    public void setKeystorePathType(int keystorePathType) {
        this.keystorePathType = keystorePathType;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public String getTruststore() {
        return this.truststore;
    }

    public void setTruststore(String truststore) {
        this.truststore = truststore;
    }

    public int getTruststoreType() {
        return this.truststoreType;
    }

    public void setTruststoreType(int truststoreType) {
        this.truststoreType = truststoreType;
    }

    public int getTruststorePathType() {
        return this.truststorePathType;
    }

    public void setTruststorePathType(int truststorePathType) {
        this.truststorePathType = truststorePathType;
    }

    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    public void setTruststorePassword(String truststorePassword) {
        this.truststorePassword = truststorePassword;
    }

    public String getCertificatePassword() {
        return this.certificatePassword;
    }

    public void setCertificatePassword(String certificatePassword) {
        this.certificatePassword = certificatePassword;
    }
}

