/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.openapi;

import com.google.common.annotations.VisibleForTesting;
import io.lighty.core.controller.api.AbstractLightyModule;
import io.lighty.core.controller.api.LightyServices;
import io.lighty.modules.northbound.restconf.community.impl.config.RestConfConfiguration;
import io.lighty.server.LightyServerBuilder;
import javax.servlet.Servlet;
import javax.ws.rs.core.Application;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.opendaylight.restconf.openapi.api.OpenApiService;
import org.opendaylight.restconf.openapi.impl.OpenApiServiceImpl;
import org.opendaylight.restconf.openapi.jaxrs.OpenApiApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiLighty
extends AbstractLightyModule {
    private static final Logger LOG = LoggerFactory.getLogger(OpenApiLighty.class);
    private static final String OPENAPI_PATH = "/openapi";
    private static final String TRUE = "true";
    private final RestConfConfiguration restConfConfiguration;
    private final LightyServerBuilder jettyServerBuilder;
    private final LightyServices lightyServices;
    private OpenApiService apiDocService;

    public OpenApiLighty(RestConfConfiguration restConfConfiguration, LightyServerBuilder jettyServerBuilder, LightyServices lightyServices) {
        this.restConfConfiguration = restConfConfiguration;
        this.jettyServerBuilder = jettyServerBuilder;
        this.lightyServices = lightyServices;
    }

    protected boolean initProcedure() {
        LOG.info("initializing openapi");
        String basePathString = this.restConfConfiguration.getRestconfServletContextPath().replaceAll("^/+", "");
        LOG.info("basePath: {}", (Object)basePathString);
        this.apiDocService = new OpenApiServiceImpl(this.lightyServices.getDOMSchemaService(), this.lightyServices.getDOMMountPointService(), basePathString);
        OpenApiApplication apiDocApplication = new OpenApiApplication(this.apiDocService);
        ServletContainer restServletContainer = new ServletContainer(ResourceConfig.forApplication((Application)apiDocApplication));
        ServletHolder restServletHolder = new ServletHolder((Servlet)restServletContainer);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        ServletContextHandler mainHandler = new ServletContextHandler((HandlerContainer)contexts, OPENAPI_PATH, true, false);
        mainHandler.addServlet(restServletHolder, "/api/v3/*");
        this.addStaticResources(mainHandler, "/explorer", "static-content");
        LOG.info("adding context handler ...");
        this.jettyServerBuilder.addContextHandler((Handler)contexts);
        return true;
    }

    protected boolean stopProcedure() {
        LOG.info("shutting down openapi ...");
        return true;
    }

    private void addStaticResources(ServletContextHandler mainHandler, String path, String servletName) {
        LOG.info("initializing openapi UI at: http(s)://{hostname:port}{}{}/index.html", (Object)OPENAPI_PATH, (Object)path);
        String externalResource = OpenApiLighty.class.getResource(path).toExternalForm();
        LOG.info("externalResource: {}", (Object)externalResource);
        DefaultServlet defaultServlet = new DefaultServlet();
        ServletHolder holderPwd = new ServletHolder(servletName, (Servlet)defaultServlet);
        holderPwd.setInitParameter("resourceBase", externalResource);
        holderPwd.setInitParameter("dirAllowed", TRUE);
        holderPwd.setInitParameter("pathInfoOnly", TRUE);
        mainHandler.addServlet(holderPwd, path + "/*");
    }

    @VisibleForTesting
    OpenApiService getApiDocService() {
        return this.apiDocService;
    }
}

