/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.modules.southbound.netconf.impl;

import io.lighty.core.controller.api.LightyServices;
import io.lighty.modules.southbound.netconf.impl.NetconfClusteredTopologyPlugin;
import io.lighty.modules.southbound.netconf.impl.NetconfSBPlugin;
import io.lighty.modules.southbound.netconf.impl.NetconfTopologyPlugin;
import io.lighty.modules.southbound.netconf.impl.config.NetconfConfiguration;
import java.util.concurrent.ExecutorService;

public final class NetconfTopologyPluginBuilder {
    private LightyServices lightyServices;
    private NetconfConfiguration configuration;
    private ExecutorService executorService = null;

    private NetconfTopologyPluginBuilder(LightyServices lightyServices, NetconfConfiguration configuration) {
        this.lightyServices = lightyServices;
        this.configuration = configuration;
    }

    public static NetconfTopologyPluginBuilder from(NetconfConfiguration configuration, LightyServices lightyServices) {
        return new NetconfTopologyPluginBuilder(lightyServices, configuration);
    }

    public NetconfTopologyPluginBuilder withExecutorService(ExecutorService executor) {
        this.executorService = executor;
        return this;
    }

    public NetconfSBPlugin build() {
        if (this.configuration.isClusterEnabled()) {
            return new NetconfClusteredTopologyPlugin(this.lightyServices, this.configuration.getTopologyId(), this.configuration.getClientDispatcher(), this.configuration.getWriteTxTimeout(), this.executorService, this.configuration.getAaaService());
        }
        return new NetconfTopologyPlugin(this.lightyServices, this.configuration.getTopologyId(), this.configuration.getClientDispatcher(), this.executorService, this.configuration.getAaaService());
    }
}

