/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.modules.southbound.netconf.impl;

import io.lighty.core.controller.api.AbstractLightyModule;
import io.lighty.core.controller.api.LightyServices;
import io.lighty.modules.southbound.netconf.impl.NetconfBaseService;
import io.lighty.modules.southbound.netconf.impl.NetconfBaseServiceImpl;
import io.lighty.modules.southbound.netconf.impl.NetconfSBPlugin;
import io.lighty.modules.southbound.netconf.impl.util.NetconfUtils;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.controller.md.sal.dom.api.DOMMountPoint;
import org.opendaylight.controller.md.sal.dom.api.DOMMountPointService;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcService;
import org.opendaylight.netconf.client.NetconfClientDispatcher;
import org.opendaylight.netconf.topology.singleton.impl.NetconfTopologyManager;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.topology.singleton.config.rev170419.Config;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.topology.singleton.config.rev170419.ConfigBuilder;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

public class NetconfClusteredTopologyPlugin
extends AbstractLightyModule
implements NetconfSBPlugin {
    private final NetconfTopologyManager topology;
    private final DOMMountPointService domMountPointService;

    public NetconfClusteredTopologyPlugin(LightyServices lightyServices, String topologyId, NetconfClientDispatcher clientDispatcher, Integer writeTxIdleTimeout, ExecutorService executorService, AAAEncryptionService encryptionService) {
        super(executorService);
        this.domMountPointService = lightyServices.getDOMMountPointService();
        Config config = new ConfigBuilder().setWriteTransactionIdleTimeout(writeTxIdleTimeout).build();
        this.topology = new NetconfTopologyManager(lightyServices.getBindingDataBroker(), lightyServices.getRpcProviderRegistry(), lightyServices.getClusterSingletonServiceProvider(), lightyServices.getScheduledThreaPool(), lightyServices.getThreadPool(), lightyServices.getActorSystemProvider(), lightyServices.getEventExecutor(), clientDispatcher, topologyId, config, lightyServices.getDOMMountPointService(), encryptionService);
    }

    protected boolean initProcedure() {
        this.topology.init();
        return true;
    }

    protected boolean stopProcedure() {
        return true;
    }

    @Override
    public boolean isClustered() {
        return true;
    }

    @Override
    public Optional<NetconfBaseService> getNetconfBaseService(NodeId nodeId) {
        DOMMountPoint domMountPoint;
        com.google.common.base.Optional optionalDOMMountPoint;
        YangInstanceIdentifier yangInstanceIdentifier = NetconfUtils.createNetConfNodeMountPointYII(nodeId);
        com.google.common.base.Optional mountPoint = this.domMountPointService.getMountPoint(yangInstanceIdentifier);
        if (mountPoint.isPresent() && (optionalDOMMountPoint = (domMountPoint = (DOMMountPoint)mountPoint.get()).getService(DOMRpcService.class)).isPresent()) {
            return Optional.of(new NetconfBaseServiceImpl(nodeId, (DOMRpcService)optionalDOMMountPoint.get(), domMountPoint.getSchemaContext()));
        }
        return Optional.empty();
    }
}

