/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.modules.southbound.netconf.impl.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import io.lighty.core.controller.api.LightyServices;
import io.lighty.core.controller.impl.config.ConfigurationException;
import io.lighty.modules.southbound.netconf.impl.config.NetconfConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.aaa.encrypt.AAAEncryptionServiceImpl;
import org.opendaylight.netconf.client.NetconfClientDispatcher;
import org.opendaylight.netconf.client.NetconfClientDispatcherImpl;
import org.opendaylight.yang.gen.v1.config.aaa.authn.encrypt.service.config.rev160915.AaaEncryptServiceConfig;
import org.opendaylight.yang.gen.v1.config.aaa.authn.encrypt.service.config.rev160915.AaaEncryptServiceConfigBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.extension.rev131210.;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160409.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.callhome.device.status.rev170112.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netconf.callhome.server.rev161109.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.extension.yang.ext.rev130709.;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfConfigUtils {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfConfigUtils.class);
    public static final String NETCONF_CONFIG_ROOT_ELEMENT_NAME = "netconf";
    public static final Set<YangModuleInfo> NETCONF_TOPOLOGY_MODELS = ImmutableSet.of((Object).YangModuleInfoImpl.getInstance(), (Object).YangModuleInfoImpl.getInstance(), (Object).YangModuleInfoImpl.getInstance(), (Object).YangModuleInfoImpl.getInstance(), (Object).YangModuleInfoImpl.getInstance(), (Object).YangModuleInfoImpl.getInstance(), (Object[])new YangModuleInfo[]{.YangModuleInfoImpl.getInstance()});
    public static final Set<YangModuleInfo> NETCONF_CALLHOME_MODELS = ImmutableSet.of((Object).YangModuleInfoImpl.getInstance(), (Object).YangModuleInfoImpl.getInstance());

    public static NetconfConfiguration createNetconfConfiguration(InputStream jsonConfigInputStream) throws ConfigurationException {
        NetconfConfiguration netconfConfiguration;
        JsonNode configNode;
        ObjectMapper mapper = new ObjectMapper();
        try {
            configNode = mapper.readTree(jsonConfigInputStream);
        }
        catch (IOException e) {
            throw new ConfigurationException("Cannot deserialize Json content to Json tree nodes", (Throwable)e);
        }
        if (!configNode.has(NETCONF_CONFIG_ROOT_ELEMENT_NAME)) {
            LOG.warn("Json config does not contain {} element. Using defaults.", (Object)NETCONF_CONFIG_ROOT_ELEMENT_NAME);
            return NetconfConfigUtils.createDefaultNetconfConfiguration();
        }
        JsonNode netconfNode = configNode.path(NETCONF_CONFIG_ROOT_ELEMENT_NAME);
        try {
            netconfConfiguration = (NetconfConfiguration)mapper.treeToValue((TreeNode)netconfNode, NetconfConfiguration.class);
        }
        catch (JsonProcessingException e) {
            throw new ConfigurationException(String.format("Cannot bind Json tree to type: %s", NetconfConfiguration.class), (Throwable)e);
        }
        return netconfConfiguration;
    }

    public static NetconfConfiguration createDefaultNetconfConfiguration() {
        return new NetconfConfiguration();
    }

    public static NetconfConfiguration injectServicesToConfig(NetconfConfiguration configuration, LightyServices lightyServices) {
        AaaEncryptServiceConfig aaaConfig = new AaaEncryptServiceConfigBuilder().setEncryptKey("V1S1ED4OMeEh").setPasswordLength(Integer.valueOf(12)).setEncryptSalt("TdtWeHbch/7xP52/rp3Usw==").setEncryptMethod("PBKDF2WithHmacSHA1").setEncryptType("AES").setEncryptIterationCount(Integer.valueOf(32768)).setEncryptKeyLength(Integer.valueOf(128)).setCipherTransforms("AES/CBC/PKCS5Padding").build();
        AAAEncryptionServiceImpl aaa = new AAAEncryptionServiceImpl(aaaConfig, lightyServices.getBindingDataBroker());
        configuration.setAaaService((AAAEncryptionService)aaa);
        return configuration;
    }

    public static NetconfConfiguration injectServicesToTopologyConfig(NetconfConfiguration configuration, LightyServices lightyServices) {
        NetconfConfigUtils.injectServicesToConfig(configuration, lightyServices);
        NetconfConfigUtils.injectClient(lightyServices, configuration);
        return configuration;
    }

    private static NetconfConfiguration injectClient(LightyServices services, NetconfConfiguration configuration) {
        NetconfClientDispatcherImpl client = new NetconfClientDispatcherImpl(services.getBossGroup(), services.getWorkerGroup(), services.getTimer());
        configuration.setClientDispatcher((NetconfClientDispatcher)client);
        return configuration;
    }
}

