/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.modules.southbound.netconf.impl;

import io.lighty.core.controller.api.LightyServices;
import io.lighty.modules.southbound.netconf.impl.NetconfClusteredTopologyPlugin;
import io.lighty.modules.southbound.netconf.impl.NetconfSBPlugin;
import io.lighty.modules.southbound.netconf.impl.NetconfTopologyPlugin;
import io.lighty.modules.southbound.netconf.impl.config.NetconfConfiguration;
import java.util.concurrent.ExecutorService;

public class NetconfTopologyPluginBuilder {
    private LightyServices lightyServices;
    private NetconfConfiguration configuration;
    private ExecutorService executorService = null;

    public NetconfTopologyPluginBuilder from(NetconfConfiguration configuration, LightyServices lightyServices) {
        this.configuration = configuration;
        this.lightyServices = lightyServices;
        return this;
    }

    public NetconfTopologyPluginBuilder withExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public NetconfSBPlugin build() {
        if (this.configuration.isClusterEnabled()) {
            return new NetconfClusteredTopologyPlugin(this.lightyServices, this.configuration.getTopologyId(), this.configuration.getClientDispatcher(), this.configuration.getWriteTxTimeout(), this.executorService, this.configuration.getAaaService());
        }
        return new NetconfTopologyPlugin(this.lightyServices, this.configuration.getTopologyId(), this.configuration.getClientDispatcher(), this.executorService, this.configuration.getAaaService());
    }
}

