/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.modules.southbound.netconf.impl.util;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.netconf.api.EffectiveOperation;
import org.opendaylight.netconf.client.mdsal.impl.NetconfMessageTransformUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.copy.config.input.target.ConfigTarget;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.edit.config.input.EditContent;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.get.config.input.source.ConfigSource;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev231121.network.topology.topology.topology.types.TopologyNetconf;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey;
import org.opendaylight.yang.svc.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Key;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AnyxmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;
import org.opendaylight.yangtools.yang.data.api.schema.builder.DataContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;

public final class NetconfUtils {
    public static final YangInstanceIdentifier.NodeIdentifier NETCONF_DELETE_CONFIG_QNAME = YangInstanceIdentifier.NodeIdentifier.create((QName)YangModuleInfoImpl.qnameOf((String)"delete-config"));
    public static final YangInstanceIdentifier.NodeIdentifier NETCONF_DELETE_CONFIG_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)NETCONF_DELETE_CONFIG_QNAME.getNodeType());
    private static final YangInstanceIdentifier.NodeIdentifier CONFIG_SOURCE_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)ConfigSource.QNAME);
    private static final YangInstanceIdentifier.NodeIdentifier CONFIG_TARGET_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)ConfigTarget.QNAME);
    private static final YangInstanceIdentifier.NodeIdentifier EDIT_CONTENT_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)EditContent.QNAME);
    private static final QName TOPOLOGY_ID_QNAME = QName.create((QName)Topology.QNAME, (String)"topology-id").intern();
    private static final QName NODE_ID_QNAME = QName.create((QName)Node.QNAME, (String)"node-id").intern();
    private static final String TOPOLOGY_NETCONF = "topology-netconf";

    private NetconfUtils() {
    }

    public static InstanceIdentifier<Node> createNetConfNodeMountPointII(NodeId nodeId) {
        KeyedInstanceIdentifier instanceIdentifier = InstanceIdentifier.create(NetworkTopology.class).child(Topology.class, (Key)new TopologyKey(new TopologyId(TopologyNetconf.QNAME.getLocalName())));
        KeyedInstanceIdentifier netconfNodeIID = instanceIdentifier.child(Node.class, (Key)new NodeKey(nodeId));
        return netconfNodeIID;
    }

    public static YangInstanceIdentifier createNetConfNodeMountPointYII(NodeId nodeId) {
        YangInstanceIdentifier yangInstanceIdentifier = YangInstanceIdentifier.builder().node(NetworkTopology.QNAME).node(Topology.QNAME).nodeWithKey(Topology.QNAME, TOPOLOGY_ID_QNAME, (Object)TOPOLOGY_NETCONF).node(Node.QNAME).nodeWithKey(Node.QNAME, NODE_ID_QNAME, (Object)nodeId.getValue()).build();
        return yangInstanceIdentifier;
    }

    public static ListenableFuture<Optional<NormalizedNode>> extractDataFromRpcResult(Optional<YangInstanceIdentifier> path, ListenableFuture<DOMRpcResult> rpcFuture) {
        return Futures.transform(rpcFuture, result -> {
            Preconditions.checkArgument((boolean)result.errors().isEmpty(), (String)"Unable to read data: %s, errors: %s", (Object)path, (Object)result.errors());
            DataContainerChild dataNode = (DataContainerChild)result.value().getChildByArg((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_DATA_NODEID);
            return NormalizedNodes.findNode((NormalizedNode)dataNode, (Iterable)((YangInstanceIdentifier)path.get()).getPathArguments());
        }, (Executor)MoreExecutors.directExecutor());
    }

    public static DataContainerChild createEditConfigStructure(EffectiveModelContext effectiveModelContext, Optional<NormalizedNode> lastChild, Optional<EffectiveOperation> operation, YangInstanceIdentifier dataPath) {
        AnyxmlNode configContent = NetconfMessageTransformUtil.createEditConfigAnyxml((EffectiveModelContext)effectiveModelContext, (YangInstanceIdentifier)dataPath, operation, lastChild);
        return (DataContainerChild)Builders.choiceBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)EDIT_CONTENT_NODEID).withChild((DataContainerChild)configContent).build();
    }

    public static ContainerNode getEditConfigContent(QName targetDatastore, DataContainerChild editStructure, Optional<EffectiveOperation> defaultOperation, boolean rollback) {
        DataContainerNodeBuilder editBuilder = Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_EDIT_CONFIG_NODEID);
        editBuilder.withChild(NetconfUtils.getTargetNode(targetDatastore));
        if (defaultOperation.isPresent()) {
            editBuilder.withChild((DataContainerChild)Builders.leafBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_DEFAULT_OPERATION_NODEID).withValue((Object)defaultOperation.get().name().toLowerCase(Locale.US)).build());
        }
        if (rollback) {
            editBuilder.withChild((DataContainerChild)Builders.leafBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_ERROR_OPTION_NODEID).withValue((Object)"rollback-on-error").build());
        }
        editBuilder.withChild(editStructure);
        return (ContainerNode)editBuilder.build();
    }

    public static DataContainerChild getSourceNode(QName sourceDatastore) {
        return (DataContainerChild)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_SOURCE_NODEID).withChild((DataContainerChild)Builders.choiceBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)CONFIG_SOURCE_NODEID).withChild((DataContainerChild)Builders.leafBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(sourceDatastore)).withValue((Object)Empty.value()).build()).build()).build();
    }

    public static ContainerNode getLockContent(QName targetDatastore) {
        return (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_LOCK_NODEID).withChild(NetconfUtils.getTargetNode(targetDatastore)).build();
    }

    public static DataContainerChild getTargetNode(QName targetDatastore) {
        return (DataContainerChild)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_TARGET_NODEID).withChild((DataContainerChild)Builders.choiceBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)CONFIG_TARGET_NODEID).withChild((DataContainerChild)Builders.leafBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(targetDatastore)).withValue((Object)Empty.value()).build()).build()).build();
    }

    public static ContainerNode getCopyConfigContent(QName sourceDatastore, QName targetDatastore) {
        return (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_COPY_CONFIG_NODEID).withChild(NetconfUtils.getTargetNode(targetDatastore)).withChild(NetconfUtils.getSourceNode(sourceDatastore)).build();
    }

    public static ContainerNode getDeleteConfigContent(QName targetDatastore) {
        return (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NETCONF_DELETE_CONFIG_NODEID).withChild(NetconfUtils.getTargetNode(targetDatastore)).build();
    }

    public static ContainerNode getValidateContent(QName sourceDatastore) {
        return (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_VALIDATE_NODEID).withChild(NetconfUtils.getSourceNode(sourceDatastore)).build();
    }

    public static ContainerNode getUnLockContent(QName targetDatastore) {
        return (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_UNLOCK_NODEID).withChild(NetconfUtils.getTargetNode(targetDatastore)).build();
    }
}

