/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.modules.southbound.netconf.impl;

import io.lighty.core.controller.api.LightyServices;
import io.lighty.modules.southbound.netconf.impl.AbstractTopologyPlugin;
import io.lighty.modules.southbound.netconf.impl.LightyDeviceActionFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.netconf.client.NetconfClientFactory;
import org.opendaylight.netconf.client.NetconfClientFactoryImpl;
import org.opendaylight.netconf.client.mdsal.api.BaseNetconfSchemaProvider;
import org.opendaylight.netconf.client.mdsal.api.CredentialProvider;
import org.opendaylight.netconf.client.mdsal.api.DeviceActionFactory;
import org.opendaylight.netconf.client.mdsal.api.SchemaResourceManager;
import org.opendaylight.netconf.client.mdsal.api.SslContextFactoryProvider;
import org.opendaylight.netconf.client.mdsal.impl.DefaultBaseNetconfSchemaProvider;
import org.opendaylight.netconf.client.mdsal.impl.DefaultCredentialProvider;
import org.opendaylight.netconf.client.mdsal.impl.DefaultSchemaResourceManager;
import org.opendaylight.netconf.client.mdsal.impl.DefaultSslContextFactoryProvider;
import org.opendaylight.netconf.common.NetconfTimer;
import org.opendaylight.netconf.common.impl.DefaultNetconfTimer;
import org.opendaylight.netconf.keystore.legacy.NetconfKeystoreService;
import org.opendaylight.netconf.keystore.legacy.impl.DefaultNetconfKeystoreService;
import org.opendaylight.netconf.topology.impl.NetconfTopologyImpl;
import org.opendaylight.netconf.topology.spi.NetconfClientConfigurationBuilderFactory;
import org.opendaylight.netconf.topology.spi.NetconfClientConfigurationBuilderFactoryImpl;
import org.opendaylight.netconf.topology.spi.NetconfTopologySchemaAssembler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetconfTopologyPlugin
extends AbstractTopologyPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfTopologyPlugin.class);
    private final String topologyId;
    private NetconfTopologyImpl netconfTopologyImpl;
    private final AAAEncryptionService encryptionService;
    private final LightyServices lightyServices;

    NetconfTopologyPlugin(LightyServices lightyServices, String topologyId, ExecutorService executorService, AAAEncryptionService encryptionService) {
        super(executorService, lightyServices.getDOMMountPointService());
        this.lightyServices = lightyServices;
        this.topologyId = topologyId;
        this.encryptionService = encryptionService;
    }

    protected boolean initProcedure() {
        DefaultBaseNetconfSchemaProvider defaultBaseNetconfSchemas = new DefaultBaseNetconfSchemaProvider(this.lightyServices.getYangParserFactory());
        DefaultNetconfKeystoreService service = new DefaultNetconfKeystoreService(this.lightyServices.getBindingDataBroker(), this.lightyServices.getRpcProviderService(), this.lightyServices.getClusterSingletonServiceProvider(), this.encryptionService);
        NetconfClientFactoryImpl netconfFactory = new NetconfClientFactoryImpl((NetconfTimer)new DefaultNetconfTimer());
        DefaultCredentialProvider credentialProvider = new DefaultCredentialProvider((NetconfKeystoreService)service);
        DefaultSslContextFactoryProvider factoryProvider = new DefaultSslContextFactoryProvider((NetconfKeystoreService)service);
        NetconfClientConfigurationBuilderFactoryImpl factory = new NetconfClientConfigurationBuilderFactoryImpl(this.encryptionService, (CredentialProvider)credentialProvider, (SslContextFactoryProvider)factoryProvider);
        NetconfTopologySchemaAssembler assembler = new NetconfTopologySchemaAssembler(1, 1, 10L, TimeUnit.SECONDS);
        DefaultSchemaResourceManager schemaResourceManager = new DefaultSchemaResourceManager(this.lightyServices.getYangParserFactory());
        this.netconfTopologyImpl = new NetconfTopologyImpl(this.topologyId, (NetconfClientFactory)netconfFactory, (NetconfTimer)new DefaultNetconfTimer(), assembler, (SchemaResourceManager)schemaResourceManager, this.lightyServices.getBindingDataBroker(), this.lightyServices.getDOMMountPointService(), this.encryptionService, (NetconfClientConfigurationBuilderFactory)factory, this.lightyServices.getRpcProviderService(), (BaseNetconfSchemaProvider)defaultBaseNetconfSchemas, (DeviceActionFactory)new LightyDeviceActionFactory());
        return true;
    }

    protected boolean stopProcedure() {
        if (this.netconfTopologyImpl != null) {
            this.netconfTopologyImpl.close();
        }
        return true;
    }

    @Override
    public boolean isClustered() {
        return false;
    }
}

