/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.modules.southbound.netconf.impl;

import io.lighty.core.controller.api.LightyServices;
import io.lighty.modules.southbound.netconf.impl.AbstractTopologyPlugin;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.netconf.client.NetconfClientFactory;
import org.opendaylight.netconf.client.NetconfClientFactoryImpl;
import org.opendaylight.netconf.client.mdsal.DeviceActionFactoryImpl;
import org.opendaylight.netconf.client.mdsal.api.BaseNetconfSchemaProvider;
import org.opendaylight.netconf.client.mdsal.api.CredentialProvider;
import org.opendaylight.netconf.client.mdsal.api.DeviceActionFactory;
import org.opendaylight.netconf.client.mdsal.api.SchemaResourceManager;
import org.opendaylight.netconf.client.mdsal.api.SslContextFactoryProvider;
import org.opendaylight.netconf.client.mdsal.impl.DefaultBaseNetconfSchemaProvider;
import org.opendaylight.netconf.client.mdsal.impl.DefaultCredentialProvider;
import org.opendaylight.netconf.client.mdsal.impl.DefaultSchemaResourceManager;
import org.opendaylight.netconf.client.mdsal.impl.DefaultSslContextFactoryProvider;
import org.opendaylight.netconf.common.NetconfTimer;
import org.opendaylight.netconf.common.impl.DefaultNetconfTimer;
import org.opendaylight.netconf.keystore.legacy.NetconfKeystoreService;
import org.opendaylight.netconf.keystore.legacy.impl.DefaultNetconfKeystoreService;
import org.opendaylight.netconf.topology.singleton.impl.NetconfTopologyManager;
import org.opendaylight.netconf.topology.spi.NetconfClientConfigurationBuilderFactory;
import org.opendaylight.netconf.topology.spi.NetconfClientConfigurationBuilderFactoryImpl;
import org.opendaylight.netconf.topology.spi.NetconfTopologySchemaAssembler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetconfClusteredTopologyPlugin
extends AbstractTopologyPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfClusteredTopologyPlugin.class);
    private final LightyServices lightyServices;
    private final AAAEncryptionService encryptionService;
    private NetconfTopologyManager topology;

    public NetconfClusteredTopologyPlugin(LightyServices lightyServices, ExecutorService executorService, AAAEncryptionService encryptionService) {
        super(executorService, lightyServices.getDOMMountPointService());
        this.lightyServices = lightyServices;
        this.encryptionService = encryptionService;
    }

    protected boolean initProcedure() {
        DefaultNetconfTimer timer = new DefaultNetconfTimer();
        DefaultBaseNetconfSchemaProvider defaultBaseNetconfSchemas = new DefaultBaseNetconfSchemaProvider(this.lightyServices.getYangParserFactory());
        DefaultSchemaResourceManager schemaResourceManager = new DefaultSchemaResourceManager(this.lightyServices.getYangParserFactory());
        DefaultNetconfKeystoreService keystoreService = new DefaultNetconfKeystoreService(this.lightyServices.getBindingDataBroker(), this.lightyServices.getRpcProviderService(), this.lightyServices.getClusterSingletonServiceProvider(), this.encryptionService);
        DefaultCredentialProvider credentialProvider = new DefaultCredentialProvider((NetconfKeystoreService)keystoreService);
        NetconfClientFactoryImpl netconfClientFactory = new NetconfClientFactoryImpl((NetconfTimer)timer);
        DefaultSslContextFactoryProvider factoryProvider = new DefaultSslContextFactoryProvider((NetconfKeystoreService)keystoreService);
        NetconfClientConfigurationBuilderFactoryImpl factory = new NetconfClientConfigurationBuilderFactoryImpl(this.encryptionService, (CredentialProvider)credentialProvider, (SslContextFactoryProvider)factoryProvider);
        this.topology = new NetconfTopologyManager((BaseNetconfSchemaProvider)defaultBaseNetconfSchemas, this.lightyServices.getBindingDataBroker(), this.lightyServices.getClusterSingletonServiceProvider(), (NetconfTimer)new DefaultNetconfTimer(), new NetconfTopologySchemaAssembler(1, 1, 0L, TimeUnit.SECONDS), this.lightyServices.getActorSystemProvider(), (NetconfClientFactory)netconfClientFactory, this.lightyServices.getDOMMountPointService(), this.encryptionService, this.lightyServices.getRpcProviderService(), (DeviceActionFactory)new DeviceActionFactoryImpl(), (SchemaResourceManager)schemaResourceManager, (NetconfClientConfigurationBuilderFactory)factory);
        return true;
    }

    protected boolean stopProcedure() {
        if (this.topology != null) {
            this.topology.close();
        }
        return true;
    }

    @Override
    public boolean isClustered() {
        return true;
    }
}

