/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.modules.southbound.netconf.impl;

import io.lighty.core.controller.api.AbstractLightyModule;
import io.lighty.core.controller.api.LightyServices;
import java.lang.annotation.Annotation;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.opendaylight.netconf.client.mdsal.DeviceActionFactoryImpl;
import org.opendaylight.netconf.client.mdsal.api.BaseNetconfSchemaProvider;
import org.opendaylight.netconf.client.mdsal.api.DeviceActionFactory;
import org.opendaylight.netconf.client.mdsal.api.SchemaResourceManager;
import org.opendaylight.netconf.client.mdsal.impl.DefaultBaseNetconfSchemaProvider;
import org.opendaylight.netconf.client.mdsal.impl.DefaultSchemaResourceManager;
import org.opendaylight.netconf.common.NetconfTimer;
import org.opendaylight.netconf.common.impl.DefaultNetconfTimer;
import org.opendaylight.netconf.topology.callhome.CallHomeMountService;
import org.opendaylight.netconf.topology.callhome.CallHomeMountSshAuthProvider;
import org.opendaylight.netconf.topology.callhome.CallHomeMountStatusReporter;
import org.opendaylight.netconf.topology.callhome.CallHomeSshAuthProvider;
import org.opendaylight.netconf.topology.callhome.CallHomeStatusRecorder;
import org.opendaylight.netconf.topology.callhome.IetfZeroTouchCallHomeServerProvider;
import org.opendaylight.netconf.topology.spi.NetconfTopologySchemaAssembler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfCallhomePlugin
extends AbstractLightyModule {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfCallhomePlugin.class);
    private final IetfZeroTouchCallHomeServerProvider provider;

    public NetconfCallhomePlugin(LightyServices lightyServices, String topologyId, ExecutorService executorService, String adress, int port) {
        super(executorService);
        DefaultBaseNetconfSchemaProvider defaultBaseNetconfSchemas = new DefaultBaseNetconfSchemaProvider(lightyServices.getYangParserFactory());
        DefaultSchemaResourceManager manager = new DefaultSchemaResourceManager(lightyServices.getYangParserFactory());
        CallHomeMountStatusReporter mountStatusReporter = new CallHomeMountStatusReporter(lightyServices.getBindingDataBroker());
        CallHomeMountSshAuthProvider authProvider = new CallHomeMountSshAuthProvider(lightyServices.getBindingDataBroker(), mountStatusReporter);
        CallHomeMountStatusReporter recorder = new CallHomeMountStatusReporter(lightyServices.getBindingDataBroker());
        DefaultNetconfTimer timer = new DefaultNetconfTimer();
        Configuration configuration = new Configuration(adress, 4334);
        CallHomeMountService dispatcher = new CallHomeMountService(topologyId, (NetconfTimer)timer, new NetconfTopologySchemaAssembler(1, 1, 10L, TimeUnit.SECONDS), (SchemaResourceManager)manager, (BaseNetconfSchemaProvider)defaultBaseNetconfSchemas, lightyServices.getBindingDataBroker(), lightyServices.getDOMMountPointService(), (DeviceActionFactory)new DeviceActionFactoryImpl());
        this.provider = new IetfZeroTouchCallHomeServerProvider((NetconfTimer)timer, dispatcher, (CallHomeSshAuthProvider)authProvider, (CallHomeStatusRecorder)recorder, (IetfZeroTouchCallHomeServerProvider.Configuration)configuration);
    }

    protected boolean initProcedure() {
        return true;
    }

    protected boolean stopProcedure() {
        try {
            this.provider.close();
        }
        catch (Exception e) {
            LOG.error("{} failed to close!", this.provider.getClass(), (Object)e);
            return false;
        }
        return true;
    }

    public static class Configuration
    implements IetfZeroTouchCallHomeServerProvider.Configuration {
        private final String host;
        private final int port;

        public Configuration(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public String host() {
            return this.host;
        }

        public int port() {
            return this.port;
        }

        public Class<? extends Annotation> annotationType() {
            return null;
        }
    }
}

