/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.modules.southbound.netconf.impl;

import io.lighty.core.controller.api.AbstractLightyModule;
import io.lighty.core.controller.api.LightyServices;
import java.util.concurrent.ExecutorService;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.netconf.callhome.mount.CallHomeMountDispatcher;
import org.opendaylight.netconf.callhome.mount.IetfZeroTouchCallHomeServerProvider;
import org.opendaylight.netconf.client.mdsal.api.BaseNetconfSchemas;
import org.opendaylight.netconf.client.mdsal.api.CredentialProvider;
import org.opendaylight.netconf.client.mdsal.api.SchemaResourceManager;
import org.opendaylight.netconf.client.mdsal.api.SslHandlerFactoryProvider;
import org.opendaylight.netconf.client.mdsal.impl.DefaultBaseNetconfSchemas;
import org.opendaylight.netconf.client.mdsal.impl.DefaultCredentialProvider;
import org.opendaylight.netconf.client.mdsal.impl.DefaultSchemaResourceManager;
import org.opendaylight.netconf.client.mdsal.impl.DefaultSslHandlerFactoryProvider;
import org.opendaylight.netconf.topology.spi.DefaultNetconfClientConfigurationBuilderFactory;
import org.opendaylight.netconf.topology.spi.NetconfClientConfigurationBuilderFactory;
import org.opendaylight.yangtools.yang.parser.api.YangParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfCallhomePlugin
extends AbstractLightyModule {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfCallhomePlugin.class);
    private final IetfZeroTouchCallHomeServerProvider provider;

    public NetconfCallhomePlugin(LightyServices lightyServices, String topologyId, ExecutorService executorService, AAAEncryptionService encryptionService) {
        super(executorService);
        DefaultBaseNetconfSchemas defaultBaseNetconfSchemas;
        try {
            defaultBaseNetconfSchemas = new DefaultBaseNetconfSchemas(lightyServices.getYangParserFactory());
        }
        catch (YangParserException e) {
            throw new RuntimeException(e);
        }
        DefaultSchemaResourceManager schemaResourceManager = new DefaultSchemaResourceManager(lightyServices.getYangParserFactory());
        DefaultCredentialProvider credentialProvider = new DefaultCredentialProvider(lightyServices.getBindingDataBroker());
        DefaultSslHandlerFactoryProvider factoryProvider = new DefaultSslHandlerFactoryProvider(lightyServices.getBindingDataBroker());
        DefaultNetconfClientConfigurationBuilderFactory factory = new DefaultNetconfClientConfigurationBuilderFactory(encryptionService, (CredentialProvider)credentialProvider, (SslHandlerFactoryProvider)factoryProvider);
        CallHomeMountDispatcher dispatcher = new CallHomeMountDispatcher(topologyId, lightyServices.getEventExecutor(), lightyServices.getScheduledThreadPool(), lightyServices.getThreadPool(), (SchemaResourceManager)schemaResourceManager, (BaseNetconfSchemas)defaultBaseNetconfSchemas, lightyServices.getBindingDataBroker(), lightyServices.getDOMMountPointService(), (NetconfClientConfigurationBuilderFactory)factory);
        this.provider = new IetfZeroTouchCallHomeServerProvider(lightyServices.getBindingDataBroker(), dispatcher);
    }

    protected boolean initProcedure() {
        return true;
    }

    protected boolean stopProcedure() {
        try {
            this.provider.close();
        }
        catch (Exception e) {
            LOG.error("{} failed to close!", this.provider.getClass(), (Object)e);
            return false;
        }
        return true;
    }
}

