/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.modules.southbound.netconf.impl;

import io.lighty.core.controller.api.AbstractLightyModule;
import io.lighty.modules.southbound.netconf.impl.NetconfBaseService;
import io.lighty.modules.southbound.netconf.impl.NetconfBaseServiceImpl;
import io.lighty.modules.southbound.netconf.impl.NetconfNmdaBaseService;
import io.lighty.modules.southbound.netconf.impl.NetconfNmdaBaseServiceImpl;
import io.lighty.modules.southbound.netconf.impl.NetconfSBPlugin;
import io.lighty.modules.southbound.netconf.impl.util.NetconfUtils;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.opendaylight.mdsal.dom.api.DOMMountPoint;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

abstract class AbstractTopologyPlugin
extends AbstractLightyModule
implements NetconfSBPlugin {
    private final DOMMountPointService domMountPointService;

    AbstractTopologyPlugin(ExecutorService executorService, DOMMountPointService domMountPointService) {
        super(executorService);
        this.domMountPointService = domMountPointService;
    }

    @Override
    public Optional<NetconfBaseService> getNetconfBaseService(NodeId nodeId) {
        Optional<DOMMountPoint> mountPoint = this.getNetconfDOMMountPoint(nodeId);
        Optional schemaService = mountPoint.flatMap(t -> t.getService(DOMSchemaService.class));
        Optional<NetconfBaseService> rpcService = mountPoint.flatMap(t -> t.getService(DOMRpcService.class));
        return rpcService.map(t -> new NetconfBaseServiceImpl(nodeId, (DOMRpcService)t, ((DOMSchemaService)schemaService.orElseThrow()).getGlobalContext()));
    }

    @Override
    public Optional<NetconfNmdaBaseService> getNetconfNmdaBaseService(NodeId nodeId) {
        Optional<DOMMountPoint> mountPoint = this.getNetconfDOMMountPoint(nodeId);
        Optional schemaService = mountPoint.flatMap(t -> t.getService(DOMSchemaService.class));
        Optional<NetconfNmdaBaseService> rpcService = mountPoint.flatMap(t -> t.getService(DOMRpcService.class));
        return rpcService.map(t -> new NetconfNmdaBaseServiceImpl(nodeId, (DOMRpcService)t, ((DOMSchemaService)schemaService.orElseThrow()).getGlobalContext()));
    }

    private Optional<DOMMountPoint> getNetconfDOMMountPoint(NodeId nodeId) {
        YangInstanceIdentifier instanceIdentifier = NetconfUtils.createNetConfNodeMountPointYII(nodeId);
        return this.domMountPointService.getMountPoint(instanceIdentifier);
    }
}

