/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.modules.southbound.netconf.impl;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import io.lighty.modules.southbound.netconf.impl.NetconfBaseService;
import io.lighty.modules.southbound.netconf.impl.util.NetconfUtils;
import java.util.Optional;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.netconf.api.EffectiveOperation;
import org.opendaylight.netconf.client.mdsal.impl.NetconfMessageTransformUtil;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AnyxmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;

public class NetconfBaseServiceImpl
implements NetconfBaseService {
    private final NodeId nodeId;
    private final DOMRpcService domRpcService;
    private final EffectiveModelContext effectiveModelContext;

    public NetconfBaseServiceImpl(NodeId nodeId, DOMRpcService domRpcService, EffectiveModelContext effectiveModelContext) {
        this.nodeId = nodeId;
        this.domRpcService = domRpcService;
        this.effectiveModelContext = effectiveModelContext;
    }

    @Override
    public ListenableFuture<? extends DOMRpcResult> get(Optional<YangInstanceIdentifier> filterYII) {
        if (filterYII.isPresent() && !filterYII.get().isEmpty()) {
            AnyxmlNode filter = NetconfMessageTransformUtil.toFilterStructure((YangInstanceIdentifier)filterYII.get(), (EffectiveModelContext)this.effectiveModelContext);
            return this.domRpcService.invokeRpc(NetconfMessageTransformUtil.NETCONF_GET_QNAME, NetconfMessageTransformUtil.wrap((QName)NetconfMessageTransformUtil.NETCONF_GET_QNAME, (DataContainerChild[])new DataContainerChild[]{filter}));
        }
        return this.domRpcService.invokeRpc(NetconfMessageTransformUtil.NETCONF_GET_QNAME, NetconfMessageTransformUtil.GET_RPC_CONTENT);
    }

    @Override
    public ListenableFuture<? extends DOMRpcResult> getConfig(QName sourceDatastore, Optional<YangInstanceIdentifier> filterYII) {
        Preconditions.checkNotNull((Object)sourceDatastore);
        if (filterYII.isPresent() && !filterYII.get().isEmpty()) {
            AnyxmlNode filter = NetconfMessageTransformUtil.toFilterStructure((YangInstanceIdentifier)filterYII.get(), (EffectiveModelContext)this.effectiveModelContext);
            return this.domRpcService.invokeRpc(NetconfMessageTransformUtil.NETCONF_GET_CONFIG_QNAME, NetconfMessageTransformUtil.wrap((QName)NetconfMessageTransformUtil.NETCONF_GET_CONFIG_QNAME, (DataContainerChild[])new DataContainerChild[]{NetconfUtils.getSourceNode(sourceDatastore), filter}));
        }
        return this.domRpcService.invokeRpc(NetconfMessageTransformUtil.NETCONF_GET_CONFIG_QNAME, NetconfMessageTransformUtil.wrap((QName)NetconfMessageTransformUtil.NETCONF_GET_CONFIG_QNAME, (DataContainerChild[])new DataContainerChild[]{NetconfUtils.getSourceNode(sourceDatastore)}));
    }

    @Override
    public ListenableFuture<? extends DOMRpcResult> editConfig(QName targetDatastore, Optional<NormalizedNode> data, YangInstanceIdentifier dataPath, Optional<EffectiveOperation> dataEffectiveOperationAttribute, Optional<EffectiveOperation> defaultEffectiveOperation, boolean rollback) {
        Preconditions.checkNotNull((Object)targetDatastore);
        DataContainerChild editStructure = NetconfUtils.createEditConfigStructure(this.effectiveModelContext, data, dataEffectiveOperationAttribute, dataPath);
        Preconditions.checkNotNull((Object)editStructure);
        return this.domRpcService.invokeRpc(NetconfMessageTransformUtil.NETCONF_EDIT_CONFIG_QNAME, NetconfUtils.getEditConfigContent(targetDatastore, editStructure, defaultEffectiveOperation, rollback));
    }

    @Override
    public ListenableFuture<? extends DOMRpcResult> copyConfig(QName sourceDatastore, QName targetDatastore) {
        Preconditions.checkNotNull((Object)sourceDatastore);
        Preconditions.checkNotNull((Object)targetDatastore);
        return this.domRpcService.invokeRpc(NetconfMessageTransformUtil.NETCONF_COPY_CONFIG_QNAME, NetconfUtils.getCopyConfigContent(sourceDatastore, targetDatastore));
    }

    @Override
    public ListenableFuture<? extends DOMRpcResult> deleteConfig(QName targetDatastore) {
        Preconditions.checkNotNull((Object)targetDatastore);
        Preconditions.checkArgument((!NetconfMessageTransformUtil.NETCONF_RUNNING_QNAME.equals((Object)targetDatastore) ? 1 : 0) != 0, (Object)"Running datastore cannot be deleted.");
        return this.domRpcService.invokeRpc(NetconfUtils.NETCONF_DELETE_CONFIG_QNAME, NetconfUtils.getDeleteConfigContent(targetDatastore));
    }

    @Override
    public ListenableFuture<? extends DOMRpcResult> lock(QName targetDatastore) {
        Preconditions.checkNotNull((Object)targetDatastore);
        return this.domRpcService.invokeRpc(NetconfMessageTransformUtil.NETCONF_LOCK_QNAME, NetconfUtils.getLockContent(targetDatastore));
    }

    @Override
    public ListenableFuture<? extends DOMRpcResult> unlock(QName targetDatastore) {
        Preconditions.checkNotNull((Object)targetDatastore);
        return this.domRpcService.invokeRpc(NetconfMessageTransformUtil.NETCONF_UNLOCK_QNAME, NetconfUtils.getUnLockContent(targetDatastore));
    }

    @Override
    public NodeId getDeviceId() {
        return this.nodeId;
    }

    @Override
    public DOMRpcService getDOMRpcService() {
        return this.domRpcService;
    }

    @Override
    public EffectiveModelContext getEffectiveModelContext() {
        return this.effectiveModelContext;
    }
}

