/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.modules.southbound.netconf.impl;

import io.lighty.core.controller.api.LightyServices;
import io.lighty.modules.southbound.netconf.impl.AbstractTopologyPlugin;
import java.util.concurrent.ExecutorService;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.netconf.client.NetconfClientDispatcher;
import org.opendaylight.netconf.client.mdsal.DeviceActionFactoryImpl;
import org.opendaylight.netconf.client.mdsal.api.BaseNetconfSchemas;
import org.opendaylight.netconf.client.mdsal.api.CredentialProvider;
import org.opendaylight.netconf.client.mdsal.api.DeviceActionFactory;
import org.opendaylight.netconf.client.mdsal.api.SchemaResourceManager;
import org.opendaylight.netconf.client.mdsal.api.SslHandlerFactoryProvider;
import org.opendaylight.netconf.client.mdsal.impl.DefaultBaseNetconfSchemas;
import org.opendaylight.netconf.client.mdsal.impl.DefaultCredentialProvider;
import org.opendaylight.netconf.client.mdsal.impl.DefaultSchemaResourceManager;
import org.opendaylight.netconf.client.mdsal.impl.DefaultSslHandlerFactoryProvider;
import org.opendaylight.netconf.topology.singleton.impl.NetconfTopologyManager;
import org.opendaylight.netconf.topology.spi.DefaultNetconfClientConfigurationBuilderFactory;
import org.opendaylight.netconf.topology.spi.NetconfClientConfigurationBuilderFactory;
import org.opendaylight.yangtools.yang.parser.api.YangParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetconfClusteredTopologyPlugin
extends AbstractTopologyPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfClusteredTopologyPlugin.class);
    private final LightyServices lightyServices;
    private final NetconfClientDispatcher clientDispatcher;
    private final AAAEncryptionService encryptionService;
    private NetconfTopologyManager topology;

    public NetconfClusteredTopologyPlugin(LightyServices lightyServices, NetconfClientDispatcher clientDispatcher, ExecutorService executorService, AAAEncryptionService encryptionService) {
        super(executorService, lightyServices.getDOMMountPointService());
        this.lightyServices = lightyServices;
        this.clientDispatcher = clientDispatcher;
        this.encryptionService = encryptionService;
    }

    protected boolean initProcedure() {
        DefaultBaseNetconfSchemas defaultBaseNetconfSchemas;
        try {
            defaultBaseNetconfSchemas = new DefaultBaseNetconfSchemas(this.lightyServices.getYangParserFactory());
        }
        catch (YangParserException e) {
            LOG.error("Failed to create DefaultBaseNetconfSchema, cause: ", (Throwable)e);
            return false;
        }
        DefaultSchemaResourceManager schemaResourceManager = new DefaultSchemaResourceManager(this.lightyServices.getYangParserFactory());
        DefaultCredentialProvider credentialProvider = new DefaultCredentialProvider(this.lightyServices.getBindingDataBroker());
        DefaultSslHandlerFactoryProvider factoryProvider = new DefaultSslHandlerFactoryProvider(this.lightyServices.getBindingDataBroker());
        DefaultNetconfClientConfigurationBuilderFactory factory = new DefaultNetconfClientConfigurationBuilderFactory(this.encryptionService, (CredentialProvider)credentialProvider, (SslHandlerFactoryProvider)factoryProvider);
        this.topology = new NetconfTopologyManager((BaseNetconfSchemas)defaultBaseNetconfSchemas, this.lightyServices.getBindingDataBroker(), this.lightyServices.getClusterSingletonServiceProvider(), this.lightyServices.getScheduledThreadPool(), this.lightyServices.getThreadPool(), this.lightyServices.getActorSystemProvider(), this.lightyServices.getEventExecutor(), this.clientDispatcher, this.lightyServices.getDOMMountPointService(), this.encryptionService, this.lightyServices.getRpcProviderService(), (DeviceActionFactory)new DeviceActionFactoryImpl(), (SchemaResourceManager)schemaResourceManager, (NetconfClientConfigurationBuilderFactory)factory);
        return true;
    }

    protected boolean stopProcedure() {
        if (this.topology != null) {
            this.topology.close();
        }
        return true;
    }

    @Override
    public boolean isClustered() {
        return true;
    }
}

