/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.modules.southbound.netconf.impl;

import io.lighty.core.controller.api.LightyServices;
import io.lighty.modules.southbound.netconf.impl.AbstractTopologyPlugin;
import java.util.concurrent.ExecutorService;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.netconf.client.NetconfClientDispatcher;
import org.opendaylight.netconf.sal.connect.api.DeviceActionFactory;
import org.opendaylight.netconf.sal.connect.api.SchemaResourceManager;
import org.opendaylight.netconf.sal.connect.impl.DefaultSchemaResourceManager;
import org.opendaylight.netconf.sal.connect.netconf.DeviceActionFactoryImpl;
import org.opendaylight.netconf.sal.connect.netconf.schema.mapping.BaseNetconfSchemas;
import org.opendaylight.netconf.sal.connect.netconf.schema.mapping.DefaultBaseNetconfSchemas;
import org.opendaylight.netconf.topology.singleton.impl.NetconfTopologyManager;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.topology.singleton.config.rev170419.Config;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.topology.singleton.config.rev170419.ConfigBuilder;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.parser.api.YangParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetconfClusteredTopologyPlugin
extends AbstractTopologyPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfClusteredTopologyPlugin.class);
    private final LightyServices lightyServices;
    private final String topologyId;
    private final NetconfClientDispatcher clientDispatcher;
    private final Integer writeTxIdleTimeout;
    private final AAAEncryptionService encryptionService;
    private NetconfTopologyManager topology;

    public NetconfClusteredTopologyPlugin(LightyServices lightyServices, String topologyId, NetconfClientDispatcher clientDispatcher, Integer writeTxIdleTimeout, ExecutorService executorService, AAAEncryptionService encryptionService) {
        super(executorService, lightyServices.getDOMMountPointService());
        this.lightyServices = lightyServices;
        this.topologyId = topologyId;
        this.clientDispatcher = clientDispatcher;
        this.writeTxIdleTimeout = writeTxIdleTimeout;
        this.encryptionService = encryptionService;
    }

    protected boolean initProcedure() {
        DefaultBaseNetconfSchemas defaultBaseNetconfSchemas;
        Config config = new ConfigBuilder().setWriteTransactionIdleTimeout(Uint16.valueOf((int)this.writeTxIdleTimeout)).build();
        try {
            defaultBaseNetconfSchemas = new DefaultBaseNetconfSchemas(this.lightyServices.getYangParserFactory());
        }
        catch (YangParserException e) {
            LOG.error("Failed to create DefaultBaseNetconfSchema, cause: ", (Throwable)e);
            return false;
        }
        DefaultSchemaResourceManager schemaResourceManager = new DefaultSchemaResourceManager(this.lightyServices.getYangParserFactory());
        this.topology = new NetconfTopologyManager((BaseNetconfSchemas)defaultBaseNetconfSchemas, this.lightyServices.getBindingDataBroker(), this.lightyServices.getDOMRpcProviderService(), this.lightyServices.getDOMActionProviderService(), this.lightyServices.getClusterSingletonServiceProvider(), this.lightyServices.getScheduledThreadPool(), this.lightyServices.getThreadPool(), this.lightyServices.getActorSystemProvider(), this.lightyServices.getEventExecutor(), this.clientDispatcher, this.topologyId, config, this.lightyServices.getDOMMountPointService(), this.encryptionService, this.lightyServices.getRpcProviderService(), (DeviceActionFactory)new DeviceActionFactoryImpl(), (SchemaResourceManager)schemaResourceManager);
        this.topology.init();
        return true;
    }

    protected boolean stopProcedure() {
        if (this.topology != null) {
            this.topology.close();
        }
        return true;
    }

    @Override
    public boolean isClustered() {
        return true;
    }
}

