/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.modules.southbound.netconf.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.MutableClassToInstanceMap;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Executor;
import org.opendaylight.mdsal.dom.api.DOMActionResult;
import org.opendaylight.mdsal.dom.api.DOMActionServiceExtension;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.spi.SimpleDOMActionResult;
import org.opendaylight.netconf.api.NetconfMessage;
import org.opendaylight.netconf.sal.connect.api.ActionTransformer;
import org.opendaylight.netconf.sal.connect.api.RemoteDeviceCommunicator;
import org.opendaylight.netconf.sal.connect.api.RemoteDeviceServices;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;

public final class LightyDOMActionService
implements RemoteDeviceServices.Actions.Normalized {
    private final ActionTransformer messageTransformer;
    private final RemoteDeviceCommunicator communicator;

    public LightyDOMActionService(ActionTransformer messageTransformer, RemoteDeviceCommunicator communicator) {
        this.messageTransformer = messageTransformer;
        this.communicator = communicator;
    }

    public ListenableFuture<? extends DOMActionResult> invokeAction(final SchemaNodeIdentifier.Absolute type, DOMDataTreeIdentifier path, ContainerNode input) {
        NetconfMessage actionRequest = this.messageTransformer.toActionRequest(type, path, (NormalizedNode)input);
        final SettableFuture settableFuture = SettableFuture.create();
        ListenableFuture responseFuture = this.communicator.sendRequest(actionRequest, type.lastNodeIdentifier());
        Futures.addCallback((ListenableFuture)responseFuture, (FutureCallback)new FutureCallback<RpcResult<NetconfMessage>>(){

            public void onSuccess(RpcResult<NetconfMessage> result) {
                Preconditions.checkNotNull(result);
                if (result.getErrors().isEmpty()) {
                    DOMActionResult actionResult = LightyDOMActionService.this.messageTransformer.toActionResult(type, (NetconfMessage)result.getResult());
                    settableFuture.set((Object)actionResult);
                } else {
                    SimpleDOMActionResult simpleDOMActionResult = new SimpleDOMActionResult((Collection)result.getErrors());
                    settableFuture.set((Object)simpleDOMActionResult);
                }
            }

            public void onFailure(Throwable cause) {
                settableFuture.set((Object)new SimpleDOMActionResult(Set.of(new ActionRpcError(cause))));
            }
        }, (Executor)MoreExecutors.directExecutor());
        return settableFuture;
    }

    public ClassToInstanceMap<DOMActionServiceExtension> getExtensions() {
        return MutableClassToInstanceMap.create();
    }

    private static final class ActionRpcError
    implements RpcError {
        private final Throwable cause;

        private ActionRpcError(Throwable cause) {
            this.cause = cause;
        }

        public ErrorSeverity getSeverity() {
            return ErrorSeverity.ERROR;
        }

        public ErrorTag getTag() {
            return null;
        }

        public String getApplicationTag() {
            return null;
        }

        public String getMessage() {
            return this.cause.getMessage();
        }

        public String getInfo() {
            return null;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public ErrorType getErrorType() {
            return ErrorType.APPLICATION;
        }
    }
}

