/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.modules.southbound.netconf.impl;

import io.lighty.core.controller.api.LightyServices;
import io.lighty.modules.southbound.netconf.impl.AbstractTopologyPlugin;
import io.lighty.modules.southbound.netconf.impl.LightyDeviceActionFactory;
import java.util.concurrent.ExecutorService;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.netconf.client.NetconfClientDispatcher;
import org.opendaylight.netconf.sal.connect.api.DeviceActionFactory;
import org.opendaylight.netconf.sal.connect.api.SchemaResourceManager;
import org.opendaylight.netconf.sal.connect.impl.DefaultSchemaResourceManager;
import org.opendaylight.netconf.sal.connect.netconf.schema.mapping.BaseNetconfSchemas;
import org.opendaylight.netconf.sal.connect.netconf.schema.mapping.DefaultBaseNetconfSchemas;
import org.opendaylight.netconf.topology.impl.NetconfTopologyImpl;
import org.opendaylight.yangtools.yang.parser.api.YangParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetconfTopologyPlugin
extends AbstractTopologyPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfTopologyPlugin.class);
    private final String topologyId;
    private final NetconfClientDispatcher clientDispatcher;
    private NetconfTopologyImpl netconfTopologyImpl;
    private final AAAEncryptionService encryptionService;
    private final LightyServices lightyServices;

    NetconfTopologyPlugin(LightyServices lightyServices, String topologyId, NetconfClientDispatcher clientDispatcher, ExecutorService executorService, AAAEncryptionService encryptionService) {
        super(executorService, lightyServices.getDOMMountPointService());
        this.lightyServices = lightyServices;
        this.topologyId = topologyId;
        this.clientDispatcher = clientDispatcher;
        this.encryptionService = encryptionService;
    }

    protected boolean initProcedure() {
        DefaultBaseNetconfSchemas defaultBaseNetconfSchemas;
        try {
            defaultBaseNetconfSchemas = new DefaultBaseNetconfSchemas(this.lightyServices.getYangParserFactory());
        }
        catch (YangParserException e) {
            LOG.error("Failed to create DefaultBaseNetconfSchema, cause: ", (Throwable)e);
            return false;
        }
        DefaultSchemaResourceManager schemaResourceManager = new DefaultSchemaResourceManager(this.lightyServices.getYangParserFactory());
        this.netconfTopologyImpl = new NetconfTopologyImpl(this.topologyId, this.clientDispatcher, this.lightyServices.getEventExecutor(), this.lightyServices.getScheduledThreadPool(), this.lightyServices.getThreadPool(), (SchemaResourceManager)schemaResourceManager, this.lightyServices.getBindingDataBroker(), this.lightyServices.getDOMMountPointService(), this.encryptionService, this.lightyServices.getRpcProviderService(), (BaseNetconfSchemas)defaultBaseNetconfSchemas, (DeviceActionFactory)new LightyDeviceActionFactory());
        this.netconfTopologyImpl.init();
        return true;
    }

    protected boolean stopProcedure() {
        if (this.netconfTopologyImpl != null) {
            this.netconfTopologyImpl.close();
        }
        return true;
    }

    @Override
    public boolean isClustered() {
        return false;
    }
}

