/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.modules.southbound.netconf.impl;

import io.lighty.core.controller.api.AbstractLightyModule;
import io.lighty.core.controller.api.LightyServices;
import io.lighty.modules.southbound.netconf.impl.LightyDeviceActionFactory;
import io.lighty.modules.southbound.netconf.impl.NetconfBaseService;
import io.lighty.modules.southbound.netconf.impl.NetconfBaseServiceImpl;
import io.lighty.modules.southbound.netconf.impl.NetconfNmdaBaseService;
import io.lighty.modules.southbound.netconf.impl.NetconfNmdaBaseServiceImpl;
import io.lighty.modules.southbound.netconf.impl.NetconfSBPlugin;
import io.lighty.modules.southbound.netconf.impl.util.NetconfUtils;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.mdsal.dom.api.DOMMountPoint;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.netconf.client.NetconfClientDispatcher;
import org.opendaylight.netconf.sal.connect.api.DeviceActionFactory;
import org.opendaylight.netconf.sal.connect.api.SchemaResourceManager;
import org.opendaylight.netconf.sal.connect.impl.DefaultSchemaResourceManager;
import org.opendaylight.netconf.sal.connect.netconf.schema.mapping.BaseNetconfSchemas;
import org.opendaylight.netconf.sal.connect.netconf.schema.mapping.DefaultBaseNetconfSchemas;
import org.opendaylight.netconf.topology.impl.NetconfTopologyImpl;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.parser.api.YangParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfTopologyPlugin
extends AbstractLightyModule
implements NetconfSBPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfTopologyPlugin.class);
    private final DOMMountPointService domMountPointService;
    private final String topologyId;
    private final NetconfClientDispatcher clientDispatcher;
    private NetconfTopologyImpl netconfTopologyImpl;
    private final AAAEncryptionService encryptionService;
    private final LightyServices lightyServices;

    NetconfTopologyPlugin(LightyServices lightyServices, String topologyId, NetconfClientDispatcher clientDispatcher, ExecutorService executorService, AAAEncryptionService encryptionService) {
        super(executorService);
        this.domMountPointService = lightyServices.getDOMMountPointService();
        this.lightyServices = lightyServices;
        this.topologyId = topologyId;
        this.clientDispatcher = clientDispatcher;
        this.encryptionService = encryptionService;
    }

    protected boolean initProcedure() {
        DefaultBaseNetconfSchemas defaultBaseNetconfSchemas;
        try {
            defaultBaseNetconfSchemas = new DefaultBaseNetconfSchemas(this.lightyServices.getYangParserFactory());
        }
        catch (YangParserException e) {
            LOG.error("Failed to create DefaultBaseNetconfSchema, cause: ", (Throwable)e);
            return false;
        }
        DefaultSchemaResourceManager schemaResourceManager = new DefaultSchemaResourceManager(this.lightyServices.getYangParserFactory());
        this.netconfTopologyImpl = new NetconfTopologyImpl(this.topologyId, this.clientDispatcher, this.lightyServices.getEventExecutor(), this.lightyServices.getScheduledThreadPool(), this.lightyServices.getThreadPool(), (SchemaResourceManager)schemaResourceManager, this.lightyServices.getBindingDataBroker(), this.lightyServices.getDOMMountPointService(), this.encryptionService, this.lightyServices.getRpcProviderService(), (BaseNetconfSchemas)defaultBaseNetconfSchemas, (DeviceActionFactory)new LightyDeviceActionFactory());
        this.netconfTopologyImpl.init();
        return true;
    }

    protected boolean stopProcedure() {
        if (this.netconfTopologyImpl != null) {
            this.netconfTopologyImpl.close();
        }
        return true;
    }

    @Override
    public boolean isClustered() {
        return false;
    }

    @Override
    public Optional<NetconfBaseService> getNetconfBaseService(NodeId nodeId) {
        Optional<DOMMountPoint> domMountPointOptional = this.getNetconfDOMMountPoint(nodeId);
        if (domMountPointOptional.isPresent()) {
            DOMMountPoint domMountPoint = domMountPointOptional.get();
            Optional service = domMountPoint.getService(DOMSchemaService.class);
            Optional domRpcServiceOptional = domMountPoint.getService(DOMRpcService.class);
            if (domRpcServiceOptional.isPresent()) {
                return Optional.of(new NetconfBaseServiceImpl(nodeId, (DOMRpcService)domRpcServiceOptional.get(), ((DOMSchemaService)service.orElseThrow()).getGlobalContext()));
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<NetconfNmdaBaseService> getNetconfNmdaBaseService(NodeId nodeId) {
        Optional<DOMMountPoint> domMountPointOptional = this.getNetconfDOMMountPoint(nodeId);
        if (domMountPointOptional.isPresent()) {
            DOMMountPoint domMountPoint = domMountPointOptional.get();
            Optional service = domMountPoint.getService(DOMSchemaService.class);
            Optional domRpcServiceOptional = domMountPoint.getService(DOMRpcService.class);
            if (domRpcServiceOptional.isPresent()) {
                return Optional.of(new NetconfNmdaBaseServiceImpl(nodeId, (DOMRpcService)domRpcServiceOptional.get(), ((DOMSchemaService)service.orElseThrow()).getGlobalContext()));
            }
        }
        return Optional.empty();
    }

    private Optional<DOMMountPoint> getNetconfDOMMountPoint(NodeId nodeId) {
        YangInstanceIdentifier yangInstanceIdentifier = NetconfUtils.createNetConfNodeMountPointYII(nodeId);
        return this.domMountPointService.getMountPoint(yangInstanceIdentifier);
    }
}

