/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.modules.southbound.netconf.impl.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.lighty.aaa.encrypt.service.impl.AAAEncryptionServiceImpl;
import io.lighty.core.controller.api.LightyServices;
import io.lighty.core.controller.impl.config.ConfigurationException;
import io.lighty.modules.southbound.netconf.impl.config.NetconfConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.netconf.client.NetconfClientDispatcher;
import org.opendaylight.netconf.client.NetconfClientDispatcherImpl;
import org.opendaylight.yang.gen.v1.config.aaa.authn.encrypt.service.config.rev160915.AaaEncryptServiceConfig;
import org.opendaylight.yang.gen.v1.config.aaa.authn.encrypt.service.config.rev160915.AaaEncryptServiceConfigBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.extension.rev131210.;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.callhome.device.status.rev170112.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.optional.rev190614.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netconf.callhome.server.rev201015.;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.extension.yang.ext.rev130709.;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetconfConfigUtils {
    public static final String NETCONF_CONFIG_ROOT_ELEMENT_NAME = "netconf";
    public static final Set<YangModuleInfo> NETCONF_TOPOLOGY_MODELS = Set.of(.YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance());
    public static final Set<YangModuleInfo> NETCONF_CALLHOME_MODELS = Set.of(.YangModuleInfoImpl.getInstance(), .YangModuleInfoImpl.getInstance());
    private static final Logger LOG = LoggerFactory.getLogger(NetconfConfigUtils.class);
    private static final SecureRandom RANDOM = new SecureRandom();

    private NetconfConfigUtils() {
    }

    public static NetconfConfiguration createNetconfConfiguration(InputStream jsonConfigInputStream) throws ConfigurationException {
        NetconfConfiguration netconfConfiguration;
        JsonNode configNode;
        ObjectMapper mapper = new ObjectMapper();
        try {
            configNode = mapper.readTree(jsonConfigInputStream);
        }
        catch (IOException e) {
            throw new ConfigurationException("Cannot deserialize Json content to Json tree nodes", (Throwable)e);
        }
        if (!configNode.has(NETCONF_CONFIG_ROOT_ELEMENT_NAME)) {
            LOG.warn("Json config does not contain {} element. Using defaults.", (Object)NETCONF_CONFIG_ROOT_ELEMENT_NAME);
            return NetconfConfigUtils.createDefaultNetconfConfiguration();
        }
        JsonNode netconfNode = configNode.path(NETCONF_CONFIG_ROOT_ELEMENT_NAME);
        try {
            netconfConfiguration = (NetconfConfiguration)mapper.treeToValue((TreeNode)netconfNode, NetconfConfiguration.class);
        }
        catch (JsonProcessingException e) {
            throw new ConfigurationException(String.format("Cannot bind Json tree to type: %s", NetconfConfiguration.class), (Throwable)e);
        }
        return netconfConfiguration;
    }

    public static NetconfConfiguration createDefaultNetconfConfiguration() {
        return new NetconfConfiguration();
    }

    public static NetconfConfiguration injectServicesToConfig(NetconfConfiguration configuration) throws ConfigurationException {
        AAAEncryptionService aaa = NetconfConfigUtils.createAAAEncryptionService(NetconfConfigUtils.getDefaultAaaEncryptServiceConfig());
        configuration.setAaaService(aaa);
        return configuration;
    }

    public static NetconfConfiguration injectServicesToTopologyConfig(NetconfConfiguration configuration, LightyServices lightyServices) throws ConfigurationException {
        NetconfConfigUtils.injectServicesToConfig(configuration);
        NetconfConfigUtils.injectClient(lightyServices, configuration);
        return configuration;
    }

    public static AaaEncryptServiceConfig getDefaultAaaEncryptServiceConfig() {
        byte[] bytes = new byte[16];
        RANDOM.nextBytes(bytes);
        String salt = new String(Base64.getEncoder().encode(bytes), StandardCharsets.UTF_8);
        return new AaaEncryptServiceConfigBuilder().setEncryptKey("V1S1ED4OMeEh").setPasswordLength(Integer.valueOf(12)).setEncryptSalt(salt).setEncryptMethod("PBKDF2WithHmacSHA1").setEncryptType("AES").setEncryptIterationCount(Integer.valueOf(32768)).setEncryptKeyLength(Integer.valueOf(128)).setCipherTransforms("AES/CBC/PKCS5Padding").build();
    }

    public static AAAEncryptionService createAAAEncryptionService(AaaEncryptServiceConfig encrySrvConfig) throws ConfigurationException {
        byte[] encryptionKeySalt = Base64.getDecoder().decode(encrySrvConfig.getEncryptSalt());
        try {
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(encrySrvConfig.getEncryptMethod());
            PBEKeySpec keySpec = new PBEKeySpec(encrySrvConfig.getEncryptKey().toCharArray(), encryptionKeySalt, encrySrvConfig.getEncryptIterationCount(), encrySrvConfig.getEncryptKeyLength());
            SecretKeySpec key = new SecretKeySpec(keyFactory.generateSecret(keySpec).getEncoded(), encrySrvConfig.getEncryptType());
            IvParameterSpec ivParameterSpec = new IvParameterSpec(encryptionKeySalt);
            Cipher encryptCipher = Cipher.getInstance(encrySrvConfig.getCipherTransforms());
            encryptCipher.init(1, (Key)key, ivParameterSpec);
            Cipher decryptCipher = Cipher.getInstance(encrySrvConfig.getCipherTransforms());
            decryptCipher.init(2, (Key)key, ivParameterSpec);
            return new AAAEncryptionServiceImpl(encryptCipher, decryptCipher);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | NoSuchPaddingException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    private static NetconfConfiguration injectClient(LightyServices services, NetconfConfiguration configuration) {
        NetconfClientDispatcherImpl client = new NetconfClientDispatcherImpl(services.getBossGroup(), services.getWorkerGroup(), services.getTimer());
        configuration.setClientDispatcher((NetconfClientDispatcher)client);
        return configuration;
    }
}

