/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.modules.southbound.netconf.impl;

import io.lighty.core.controller.api.AbstractLightyModule;
import io.lighty.core.controller.api.LightyServices;
import io.lighty.modules.southbound.netconf.impl.NetconfBaseService;
import io.lighty.modules.southbound.netconf.impl.NetconfBaseServiceImpl;
import io.lighty.modules.southbound.netconf.impl.NetconfNmdaBaseService;
import io.lighty.modules.southbound.netconf.impl.NetconfNmdaBaseServiceImpl;
import io.lighty.modules.southbound.netconf.impl.NetconfSBPlugin;
import io.lighty.modules.southbound.netconf.impl.util.NetconfUtils;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.mdsal.dom.api.DOMMountPoint;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.netconf.client.NetconfClientDispatcher;
import org.opendaylight.netconf.sal.connect.api.DeviceActionFactory;
import org.opendaylight.netconf.sal.connect.api.SchemaResourceManager;
import org.opendaylight.netconf.sal.connect.impl.DefaultSchemaResourceManager;
import org.opendaylight.netconf.sal.connect.netconf.DeviceActionFactoryImpl;
import org.opendaylight.netconf.sal.connect.netconf.schema.mapping.BaseNetconfSchemas;
import org.opendaylight.netconf.sal.connect.netconf.schema.mapping.DefaultBaseNetconfSchemas;
import org.opendaylight.netconf.topology.singleton.impl.NetconfTopologyManager;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.topology.singleton.config.rev170419.Config;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.topology.singleton.config.rev170419.ConfigBuilder;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.parser.api.YangParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfClusteredTopologyPlugin
extends AbstractLightyModule
implements NetconfSBPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfClusteredTopologyPlugin.class);
    private final DOMMountPointService domMountPointService;
    private final LightyServices lightyServices;
    private final String topologyId;
    private final NetconfClientDispatcher clientDispatcher;
    private final Integer writeTxIdleTimeout;
    private final AAAEncryptionService encryptionService;

    public NetconfClusteredTopologyPlugin(LightyServices lightyServices, String topologyId, NetconfClientDispatcher clientDispatcher, Integer writeTxIdleTimeout, ExecutorService executorService, AAAEncryptionService encryptionService) {
        super(executorService);
        this.domMountPointService = lightyServices.getDOMMountPointService();
        this.lightyServices = lightyServices;
        this.topologyId = topologyId;
        this.clientDispatcher = clientDispatcher;
        this.writeTxIdleTimeout = writeTxIdleTimeout;
        this.encryptionService = encryptionService;
    }

    protected boolean initProcedure() {
        DefaultBaseNetconfSchemas defaultBaseNetconfSchemas;
        Config config = new ConfigBuilder().setWriteTransactionIdleTimeout(Uint16.valueOf((int)this.writeTxIdleTimeout)).build();
        try {
            defaultBaseNetconfSchemas = new DefaultBaseNetconfSchemas(this.lightyServices.getYangParserFactory());
        }
        catch (YangParserException e) {
            LOG.error("Failed to create DefaultBaseNetconfSchema, cause: ", (Throwable)e);
            return false;
        }
        DefaultSchemaResourceManager schemaResourceManager = new DefaultSchemaResourceManager(this.lightyServices.getYangParserFactory());
        NetconfTopologyManager topology = new NetconfTopologyManager((BaseNetconfSchemas)defaultBaseNetconfSchemas, this.lightyServices.getBindingDataBroker(), this.lightyServices.getDOMRpcProviderService(), this.lightyServices.getDOMActionProviderService(), this.lightyServices.getClusterSingletonServiceProvider(), this.lightyServices.getScheduledThreadPool(), this.lightyServices.getThreadPool(), this.lightyServices.getActorSystemProvider(), this.lightyServices.getEventExecutor(), this.clientDispatcher, this.topologyId, config, this.lightyServices.getDOMMountPointService(), this.encryptionService, this.lightyServices.getRpcProviderService(), (DeviceActionFactory)new DeviceActionFactoryImpl(), (SchemaResourceManager)schemaResourceManager);
        topology.init();
        return true;
    }

    protected boolean stopProcedure() {
        return true;
    }

    @Override
    public boolean isClustered() {
        return true;
    }

    @Override
    public Optional<NetconfBaseService> getNetconfBaseService(NodeId nodeId) {
        Optional<DOMMountPoint> domMountPointOptional = this.getNetconfDOMMountPoint(nodeId);
        if (domMountPointOptional.isPresent()) {
            DOMMountPoint domMountPoint = domMountPointOptional.get();
            Optional service = domMountPoint.getService(DOMSchemaService.class);
            Optional domRpcServiceOptional = domMountPoint.getService(DOMRpcService.class);
            if (domRpcServiceOptional.isPresent()) {
                return Optional.of(new NetconfBaseServiceImpl(nodeId, (DOMRpcService)domRpcServiceOptional.get(), ((DOMSchemaService)service.orElseThrow()).getGlobalContext()));
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<NetconfNmdaBaseService> getNetconfNmdaBaseService(NodeId nodeId) {
        Optional<DOMMountPoint> domMountPointOptional = this.getNetconfDOMMountPoint(nodeId);
        if (domMountPointOptional.isPresent()) {
            DOMMountPoint domMountPoint = domMountPointOptional.get();
            Optional service = domMountPoint.getService(DOMSchemaService.class);
            Optional domRpcServiceOptional = domMountPoint.getService(DOMRpcService.class);
            if (domRpcServiceOptional.isPresent()) {
                return Optional.of(new NetconfNmdaBaseServiceImpl(nodeId, (DOMRpcService)domRpcServiceOptional.get(), ((DOMSchemaService)service.orElseThrow()).getGlobalContext()));
            }
        }
        return Optional.empty();
    }

    private Optional<DOMMountPoint> getNetconfDOMMountPoint(NodeId nodeId) {
        YangInstanceIdentifier yangInstanceIdentifier = NetconfUtils.createNetConfNodeMountPointYII(nodeId);
        return this.domMountPointService.getMountPoint(yangInstanceIdentifier);
    }
}

