/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.modules.southbound.netconf.impl;

import io.lighty.core.controller.api.AbstractLightyModule;
import io.lighty.core.controller.api.LightyServices;
import io.lighty.modules.southbound.netconf.impl.NetconfBaseService;
import io.lighty.modules.southbound.netconf.impl.NetconfBaseServiceImpl;
import io.lighty.modules.southbound.netconf.impl.NetconfNmdaBaseService;
import io.lighty.modules.southbound.netconf.impl.NetconfNmdaBaseServiceImpl;
import io.lighty.modules.southbound.netconf.impl.NetconfSBPlugin;
import io.lighty.modules.southbound.netconf.impl.util.NetconfUtils;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.mdsal.dom.api.DOMMountPoint;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.netconf.client.NetconfClientDispatcher;
import org.opendaylight.netconf.sal.connect.api.SchemaResourceManager;
import org.opendaylight.netconf.sal.connect.impl.DefaultSchemaResourceManager;
import org.opendaylight.netconf.sal.connect.netconf.schema.mapping.BaseNetconfSchemas;
import org.opendaylight.netconf.sal.connect.netconf.schema.mapping.DefaultBaseNetconfSchemas;
import org.opendaylight.netconf.topology.singleton.impl.NetconfTopologyManager;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.topology.singleton.config.rev170419.Config;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.topology.singleton.config.rev170419.ConfigBuilder;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

public class NetconfClusteredTopologyPlugin
extends AbstractLightyModule
implements NetconfSBPlugin {
    private final NetconfTopologyManager topology;
    private final DOMMountPointService domMountPointService;

    public NetconfClusteredTopologyPlugin(LightyServices lightyServices, String topologyId, NetconfClientDispatcher clientDispatcher, Integer writeTxIdleTimeout, ExecutorService executorService, AAAEncryptionService encryptionService) {
        super(executorService);
        this.domMountPointService = lightyServices.getDOMMountPointService();
        Config config = new ConfigBuilder().setWriteTransactionIdleTimeout(Uint16.valueOf((int)writeTxIdleTimeout)).build();
        DefaultBaseNetconfSchemas defaultBaseNetconfSchemas = new DefaultBaseNetconfSchemas(lightyServices.getYangParserFactory());
        DefaultSchemaResourceManager schemaResourceManager = new DefaultSchemaResourceManager(lightyServices.getYangParserFactory());
        this.topology = new NetconfTopologyManager((BaseNetconfSchemas)defaultBaseNetconfSchemas, lightyServices.getBindingDataBroker(), lightyServices.getDOMRpcProviderService(), null, lightyServices.getClusterSingletonServiceProvider(), lightyServices.getScheduledThreadPool(), lightyServices.getThreadPool(), lightyServices.getActorSystemProvider(), lightyServices.getEventExecutor(), clientDispatcher, topologyId, config, lightyServices.getDOMMountPointService(), encryptionService, null, (SchemaResourceManager)schemaResourceManager);
    }

    protected boolean initProcedure() {
        this.topology.init();
        return true;
    }

    protected boolean stopProcedure() {
        return true;
    }

    @Override
    public boolean isClustered() {
        return true;
    }

    @Override
    public Optional<NetconfBaseService> getNetconfBaseService(NodeId nodeId) {
        DOMMountPoint domMountPoint;
        Optional domRpcServiceOptional;
        Optional<DOMMountPoint> domMountPointOptional = this.getNetconfDOMMountPoint(nodeId);
        if (domMountPointOptional.isPresent() && (domRpcServiceOptional = (domMountPoint = domMountPointOptional.get()).getService(DOMRpcService.class)).isPresent()) {
            return Optional.of(new NetconfBaseServiceImpl(nodeId, (DOMRpcService)domRpcServiceOptional.get(), domMountPoint.getSchemaContext()));
        }
        return Optional.empty();
    }

    @Override
    public Optional<NetconfNmdaBaseService> getNetconfNmdaBaseService(NodeId nodeId) {
        DOMMountPoint domMountPoint;
        Optional domRpcServiceOptional;
        Optional<DOMMountPoint> domMountPointOptional = this.getNetconfDOMMountPoint(nodeId);
        if (domMountPointOptional.isPresent() && (domRpcServiceOptional = (domMountPoint = domMountPointOptional.get()).getService(DOMRpcService.class)).isPresent()) {
            return Optional.of(new NetconfNmdaBaseServiceImpl(nodeId, (DOMRpcService)domRpcServiceOptional.get(), domMountPoint.getSchemaContext()));
        }
        return Optional.empty();
    }

    private Optional<DOMMountPoint> getNetconfDOMMountPoint(NodeId nodeId) {
        YangInstanceIdentifier yangInstanceIdentifier = NetconfUtils.createNetConfNodeMountPointYII(nodeId);
        return this.domMountPointService.getMountPoint(yangInstanceIdentifier);
    }
}

