/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.modules.southbound.netconf.impl;

import io.lighty.core.controller.api.AbstractLightyModule;
import io.lighty.core.controller.api.LightyServices;
import java.util.concurrent.ExecutorService;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.netconf.callhome.mount.CallHomeMountDispatcher;
import org.opendaylight.netconf.callhome.mount.IetfZeroTouchCallHomeServerProvider;
import org.opendaylight.netconf.sal.connect.api.SchemaResourceManager;
import org.opendaylight.netconf.sal.connect.impl.DefaultSchemaResourceManager;
import org.opendaylight.netconf.sal.connect.netconf.schema.mapping.BaseNetconfSchemas;
import org.opendaylight.netconf.sal.connect.netconf.schema.mapping.DefaultBaseNetconfSchemas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfCallhomePlugin
extends AbstractLightyModule {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfCallhomePlugin.class);
    private final IetfZeroTouchCallHomeServerProvider provider;

    public NetconfCallhomePlugin(LightyServices lightyServices, String topologyId, ExecutorService executorService, AAAEncryptionService encryptionService) {
        super(executorService);
        DefaultBaseNetconfSchemas defaultBaseNetconfSchemas = new DefaultBaseNetconfSchemas(lightyServices.getYangParserFactory());
        DefaultSchemaResourceManager schemaResourceManager = new DefaultSchemaResourceManager(lightyServices.getYangParserFactory());
        CallHomeMountDispatcher dispatcher = new CallHomeMountDispatcher(topologyId, lightyServices.getEventExecutor(), lightyServices.getScheduledThreadPool(), lightyServices.getThreadPool(), (SchemaResourceManager)schemaResourceManager, (BaseNetconfSchemas)defaultBaseNetconfSchemas, lightyServices.getBindingDataBroker(), lightyServices.getDOMMountPointService(), encryptionService);
        this.provider = new IetfZeroTouchCallHomeServerProvider(lightyServices.getBindingDataBroker(), dispatcher);
    }

    protected boolean initProcedure() {
        this.provider.init();
        return true;
    }

    protected boolean stopProcedure() {
        try {
            this.provider.close();
        }
        catch (Exception e) {
            LOG.error("{} failed to close!", this.provider.getClass(), (Object)e);
            return false;
        }
        return true;
    }
}

