/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.modules.southbound.netconf.impl;

import io.lighty.core.controller.api.AbstractLightyModule;
import io.lighty.core.controller.api.LightyServices;
import io.lighty.modules.southbound.netconf.impl.LightyDeviceActionFactory;
import io.lighty.modules.southbound.netconf.impl.NetconfBaseService;
import io.lighty.modules.southbound.netconf.impl.NetconfBaseServiceImpl;
import io.lighty.modules.southbound.netconf.impl.NetconfNmdaBaseService;
import io.lighty.modules.southbound.netconf.impl.NetconfNmdaBaseServiceImpl;
import io.lighty.modules.southbound.netconf.impl.NetconfSBPlugin;
import io.lighty.modules.southbound.netconf.impl.util.NetconfUtils;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.mdsal.dom.api.DOMMountPoint;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.netconf.client.NetconfClientDispatcher;
import org.opendaylight.netconf.sal.connect.api.DeviceActionFactory;
import org.opendaylight.netconf.topology.api.SchemaRepositoryProvider;
import org.opendaylight.netconf.topology.impl.NetconfTopologyImpl;
import org.opendaylight.netconf.topology.impl.SchemaRepositoryProviderImpl;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

public class NetconfTopologyPlugin
extends AbstractLightyModule
implements NetconfSBPlugin {
    private final NetconfTopologyImpl topology;
    private final DOMMountPointService domMountPointService;

    NetconfTopologyPlugin(LightyServices lightyServices, String topologyId, NetconfClientDispatcher clientDispatcher, ExecutorService executorService, AAAEncryptionService encryptionService) {
        super(executorService);
        this.domMountPointService = lightyServices.getDOMMountPointService();
        SchemaRepositoryProviderImpl schemaRepositoryProvider = new SchemaRepositoryProviderImpl("shared-schema-repository-impl");
        this.topology = new NetconfTopologyImpl(topologyId, clientDispatcher, lightyServices.getEventExecutor(), lightyServices.getScheduledThreaPool(), lightyServices.getThreadPool(), (SchemaRepositoryProvider)schemaRepositoryProvider, lightyServices.getBindingDataBroker(), lightyServices.getDOMMountPointService(), encryptionService, (DeviceActionFactory)new LightyDeviceActionFactory());
    }

    protected boolean initProcedure() {
        this.topology.init();
        return true;
    }

    protected boolean stopProcedure() {
        return true;
    }

    @Override
    public boolean isClustered() {
        return false;
    }

    @Override
    public Optional<NetconfBaseService> getNetconfBaseService(NodeId nodeId) {
        DOMMountPoint domMountPoint;
        Optional domRpcServiceOptional;
        Optional<DOMMountPoint> domMountPointOptional = this.getNetconfDOMMountPoint(nodeId);
        if (domMountPointOptional.isPresent() && (domRpcServiceOptional = (domMountPoint = domMountPointOptional.get()).getService(DOMRpcService.class)).isPresent()) {
            return Optional.of(new NetconfBaseServiceImpl(nodeId, (DOMRpcService)domRpcServiceOptional.get(), domMountPoint.getSchemaContext()));
        }
        return Optional.empty();
    }

    @Override
    public Optional<NetconfNmdaBaseService> getNetconfNmdaBaseService(NodeId nodeId) {
        DOMMountPoint domMountPoint;
        Optional domRpcServiceOptional;
        Optional<DOMMountPoint> domMountPointOptional = this.getNetconfDOMMountPoint(nodeId);
        if (domMountPointOptional.isPresent() && (domRpcServiceOptional = (domMountPoint = domMountPointOptional.get()).getService(DOMRpcService.class)).isPresent()) {
            return Optional.of(new NetconfNmdaBaseServiceImpl(nodeId, (DOMRpcService)domRpcServiceOptional.get(), domMountPoint.getSchemaContext()));
        }
        return Optional.empty();
    }

    private Optional<DOMMountPoint> getNetconfDOMMountPoint(NodeId nodeId) {
        YangInstanceIdentifier yangInstanceIdentifier = NetconfUtils.createNetConfNodeMountPointYII(nodeId);
        return this.domMountPointService.getMountPoint(yangInstanceIdentifier);
    }
}

