/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.modules.southbound.netconf.impl;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import io.lighty.modules.southbound.netconf.impl.NetconfBaseServiceImpl;
import io.lighty.modules.southbound.netconf.impl.NetconfNmdaBaseService;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.netconf.api.ModifyAction;
import org.opendaylight.netconf.sal.connect.netconf.util.NetconfMessageTransformUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.nmda.rev190107.edit.data.input.EditContent;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yangtools.rfc7952.data.api.NormalizedMetadata;
import org.opendaylight.yangtools.rfc7952.data.util.ImmutableMetadataNormalizedAnydata;
import org.opendaylight.yangtools.rfc7952.data.util.ImmutableNormalizedMetadata;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AnydataNode;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedAnydata;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableAnydataNodeBuilder;
import org.opendaylight.yangtools.yang.data.util.ImmutableNormalizedAnydata;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public class NetconfNmdaBaseServiceImpl
extends NetconfBaseServiceImpl
implements NetconfNmdaBaseService {
    public static final QName NETCONF_NMDA_EXTENSION_QNAME = QName.create((String)"urn:ietf:params:xml:ns:yang:ietf-netconf-nmda", (String)"2019-01-07", (String)"ietf-netconf-nmda").intern();
    public static final QName NETCONF_GET_DATA_QNAME = QName.create((QName)NETCONF_NMDA_EXTENSION_QNAME, (String)"get-data").intern();
    public static final QName NETCONF_EDIT_DATA_QNAME = QName.create((QName)NETCONF_NMDA_EXTENSION_QNAME, (String)"edit-data").intern();
    private static final YangInstanceIdentifier.NodeIdentifier NETCONF_FILTER_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QName)NETCONF_GET_DATA_QNAME, (String)"subtree-filter").intern());
    private static final YangInstanceIdentifier.NodeIdentifier NETCONF_FILTER_CHOICE_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QName)NETCONF_GET_DATA_QNAME, (String)"filter-spec").intern());
    private static final YangInstanceIdentifier.NodeIdentifier NETCONF_ORIGIN_FILTERS_CHOICE_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QName)NETCONF_GET_DATA_QNAME, (String)"origin-filters").intern());
    private static final YangInstanceIdentifier.NodeIdentifier NETCONF_DATASTORE_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QName)NETCONF_GET_DATA_QNAME, (String)"datastore").intern());
    private static final YangInstanceIdentifier.NodeIdentifier NETCONF_CONFIG_FILTER_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QName)NETCONF_GET_DATA_QNAME, (String)"config-filter").intern());
    private static final YangInstanceIdentifier.NodeIdentifier NETCONF_MAX_DEPTH_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QName)NETCONF_GET_DATA_QNAME, (String)"max-depth").intern());
    private static final YangInstanceIdentifier.NodeIdentifier NETCONF_ORIGIN_FILTER_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QName)NETCONF_GET_DATA_QNAME, (String)"origin-filter").intern());
    private static final YangInstanceIdentifier.NodeIdentifier NETCONF_NEGATED_ORIGIN_FILTER_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QName)NETCONF_GET_DATA_QNAME, (String)"negated-origin-filter").intern());
    private static final YangInstanceIdentifier.NodeIdentifier NETCONF_WITH_ORIGIN_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QName)NETCONF_GET_DATA_QNAME, (String)"with-origin").intern());
    private static final QName NETCONF_OPERATION_QNAME_LEGACY = NetconfMessageTransformUtil.NETCONF_OPERATION_QNAME.withoutRevision().intern();
    private static final YangInstanceIdentifier.NodeIdentifier NETCONF_EDIT_DATA_CONFIG_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QName)NETCONF_EDIT_DATA_QNAME, (String)"config").intern());
    private static final YangInstanceIdentifier.NodeIdentifier NETCONF_DEFAULT_OPERATION_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QName)NETCONF_EDIT_DATA_QNAME, (String)"default-operation").intern());

    public NetconfNmdaBaseServiceImpl(NodeId nodeId, DOMRpcService domRpcService, SchemaContext schemaContext) {
        super(nodeId, domRpcService, schemaContext);
    }

    @Override
    public ListenableFuture<? extends DOMRpcResult> getData(QName sourceDatastore, Optional<YangInstanceIdentifier> filterYII, Optional<Boolean> configFilter, Optional<Integer> maxDepth, Optional<Set<QName>> originFilter, Optional<Boolean> negateOriginFilter, Optional<Boolean> withOrigin) {
        ArrayList<Object> getDataChildren = new ArrayList<Object>();
        getDataChildren.add(this.getDatastoreNode(Objects.requireNonNull(sourceDatastore)));
        if (filterYII.isPresent()) {
            NormalizedNode filterNN = ImmutableNodes.fromInstanceId((SchemaContext)this.getSchemaContext(), (YangInstanceIdentifier)filterYII.get());
            QName nodeType = filterNN.getNodeType();
            Optional dataTreeChild = this.getSchemaContext().findDataTreeChild(nodeType);
            AnydataNode subtreeFilter = (AnydataNode)ImmutableAnydataNodeBuilder.create(NormalizedAnydata.class).withNodeIdentifier((YangInstanceIdentifier.PathArgument)NETCONF_FILTER_NODEID).withValue((Object)new ImmutableNormalizedAnydata(this.getSchemaContext(), (DataSchemaNode)dataTreeChild.orElseThrow(() -> new NoSuchElementException(String.format("Node [%s] was not found in schema context", nodeType.toString()))), filterNN)).build();
            ChoiceNode filterSpecChoice = (ChoiceNode)Builders.choiceBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NETCONF_FILTER_CHOICE_NODEID).withChild((DataContainerChild)subtreeFilter).build();
            getDataChildren.add(filterSpecChoice);
        }
        configFilter.ifPresent(configFilterValue -> getDataChildren.add(this.getConfigFilterNode((Boolean)configFilterValue)));
        if (originFilter.isPresent()) {
            DataContainerChild<?, ?> originFilterChild = negateOriginFilter.isPresent() && negateOriginFilter.get() != false ? this.getNegatedOriginFilterNode(originFilter.get()) : this.getOriginFilterNode(originFilter.get());
            ChoiceNode originFilterSpecChoice = (ChoiceNode)Builders.choiceBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NETCONF_ORIGIN_FILTERS_CHOICE_NODEID).withChild(originFilterChild).build();
            getDataChildren.add(originFilterSpecChoice);
        }
        maxDepth.ifPresent(maxDepthValue -> getDataChildren.add(this.getMaxDepthNode((Integer)maxDepthValue)));
        if (withOrigin.isPresent() && withOrigin.get().booleanValue()) {
            getDataChildren.add(this.getWithOriginNode());
        }
        DataContainerChild[] getDataChildrenArray = new DataContainerChild[getDataChildren.size()];
        getDataChildrenArray = getDataChildren.toArray(getDataChildrenArray);
        return this.getDOMRpcService().invokeRpc(NetconfMessageTransformUtil.toPath((QName)NETCONF_GET_DATA_QNAME), (NormalizedNode)NetconfMessageTransformUtil.wrap((QName)NETCONF_GET_DATA_QNAME, (DataContainerChild[])getDataChildrenArray));
    }

    @Override
    public ListenableFuture<? extends DOMRpcResult> editData(QName targetDatastore, Optional<NormalizedNode<?, ?>> data, YangInstanceIdentifier dataPath, Optional<ModifyAction> dataModifyActionAttribute, Optional<ModifyAction> defaultModifyAction) {
        NormalizedNode editNNContent = ImmutableNodes.fromInstanceId((SchemaContext)this.getSchemaContext(), (YangInstanceIdentifier)dataPath, data.orElseThrow(() -> new NoSuchElementException("Data is missing")));
        QName nodeType = editNNContent.getNodeType();
        Optional dataTreeChild = this.getSchemaContext().findDataTreeChild(nodeType);
        NormalizedMetadata metadata = dataModifyActionAttribute.map(oper -> this.leafMetadata(dataPath, (ModifyAction)oper)).orElse(null);
        AnydataNode editContent = (AnydataNode)ImmutableAnydataNodeBuilder.create(NormalizedAnydata.class).withNodeIdentifier((YangInstanceIdentifier.PathArgument)NETCONF_EDIT_DATA_CONFIG_NODEID).withValue((Object)new ImmutableMetadataNormalizedAnydata(this.getSchemaContext(), (DataSchemaNode)dataTreeChild.orElseThrow(() -> new NoSuchElementException(String.format("Node [%s] was not found in schema context", nodeType.toString()))), editNNContent, metadata)).build();
        ChoiceNode editStructure = (ChoiceNode)Builders.choiceBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.toId((QName)EditContent.QNAME)).withChild((DataContainerChild)editContent).build();
        Preconditions.checkNotNull((Object)editStructure);
        return this.getDOMRpcService().invokeRpc(NetconfMessageTransformUtil.toPath((QName)NETCONF_EDIT_DATA_QNAME), (NormalizedNode)NetconfMessageTransformUtil.wrap((QName)NETCONF_EDIT_DATA_QNAME, (DataContainerChild[])new DataContainerChild[]{this.getDatastoreNode(Objects.requireNonNull(targetDatastore)), this.getDefaultOperationNode(defaultModifyAction.orElseThrow(() -> new NoSuchElementException("Default Modify Action is missing"))), editStructure}));
    }

    private DataContainerChild<?, ?> getDatastoreNode(QName datastore) {
        return (DataContainerChild)Builders.leafBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NETCONF_DATASTORE_NODEID).withValue((Object)datastore).build();
    }

    private DataContainerChild<?, ?> getConfigFilterNode(Boolean configFilter) {
        return (DataContainerChild)Builders.leafBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NETCONF_CONFIG_FILTER_NODEID).withValue((Object)configFilter).build();
    }

    private DataContainerChild<?, ?> getMaxDepthNode(Integer maxDepth) {
        return (DataContainerChild)Builders.leafBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NETCONF_MAX_DEPTH_NODEID).withValue((Object)maxDepth).build();
    }

    private DataContainerChild<?, ?> getOriginFilterNode(Set<QName> originFilter) {
        ArrayList leafSetEntryNodes = new ArrayList();
        originFilter.forEach(originFilterEntry -> leafSetEntryNodes.add(Builders.leafSetEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeWithValue(NETCONF_ORIGIN_FILTER_NODEID.getNodeType(), originFilterEntry)).withValue(originFilterEntry).build()));
        return (DataContainerChild)Builders.leafSetBuilder().withNodeIdentifier(NETCONF_ORIGIN_FILTER_NODEID).withValue(leafSetEntryNodes).build();
    }

    private DataContainerChild<?, ?> getNegatedOriginFilterNode(Set<QName> negatedOriginFilter) {
        ArrayList leafSetEntryNodes = new ArrayList();
        negatedOriginFilter.forEach(negatedOriginFilterEntry -> leafSetEntryNodes.add(Builders.leafSetEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeWithValue(NETCONF_NEGATED_ORIGIN_FILTER_NODEID.getNodeType(), negatedOriginFilterEntry)).withValue(negatedOriginFilterEntry).build()));
        return (DataContainerChild)Builders.leafSetBuilder().withNodeIdentifier(NETCONF_NEGATED_ORIGIN_FILTER_NODEID).withValue(leafSetEntryNodes).build();
    }

    private DataContainerChild<?, ?> getWithOriginNode() {
        return (DataContainerChild)Builders.leafBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NETCONF_WITH_ORIGIN_NODEID).withValue((Object)Empty.getInstance()).build();
    }

    private DataContainerChild<?, ?> getDefaultOperationNode(ModifyAction defaultModifyAction) {
        String opString = defaultModifyAction.name().toLowerCase(Locale.US);
        return (DataContainerChild)Builders.leafBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NETCONF_DEFAULT_OPERATION_NODEID).withValue((Object)opString).build();
    }

    private NormalizedMetadata leafMetadata(YangInstanceIdentifier path, ModifyAction oper) {
        ImmutableNormalizedMetadata currentMeta;
        List args = path.getPathArguments();
        ArrayDeque<ImmutableNormalizedMetadata.Builder> builders = new ArrayDeque<ImmutableNormalizedMetadata.Builder>(args.size());
        for (YangInstanceIdentifier.PathArgument arg : args) {
            builders.push(ImmutableNormalizedMetadata.builder().withIdentifier(arg));
        }
        Optional.ofNullable(builders.peek()).ifPresent(builder -> builder.withAnnotation(NETCONF_OPERATION_QNAME_LEGACY, (Object)oper.toString().toLowerCase(Locale.US)));
        while (true) {
            currentMeta = ((ImmutableNormalizedMetadata.Builder)builders.pop()).build();
            ImmutableNormalizedMetadata.Builder parent = (ImmutableNormalizedMetadata.Builder)builders.peek();
            if (parent == null) break;
            parent.withChild(currentMeta);
        }
        return currentMeta;
    }
}

