/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.modules.southbound.netconf.impl.util;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Optional;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.netconf.sal.connect.netconf.util.NetconfMessageTransformUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.copy.config.input.target.ConfigTarget;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.edit.config.input.EditContent;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.get.config.input.source.ConfigSource;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.network.topology.topology.topology.types.TopologyNetconf;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.ModifyAction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AnyXmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeAttrBuilder;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public final class NetconfUtils {
    private static final String NETCONF_TOPOLOGY_NAMESPACE = "urn:TBD:params:xml:ns:yang:network-topology";
    private static final String NETCONF_TOPOLOGY_VERSION = "2013-10-21";
    private static final String TOPOLOGY_ID = "topology-id";
    private static final String TOPOLOGY_NETCONF = "topology-netconf";
    private static final String NODE_ID = "node-id";
    public static final QName NETCONF_DELETE_CONFIG_QNAME = QName.create((QName)NetconfMessageTransformUtil.NETCONF_QNAME, (String)"delete-config").intern();

    private NetconfUtils() {
    }

    public static InstanceIdentifier<Node> createNetConfNodeMountPointII(NodeId nodeId) {
        KeyedInstanceIdentifier instanceIdentifier = InstanceIdentifier.create(NetworkTopology.class).child(Topology.class, (Identifier)new TopologyKey(new TopologyId(TopologyNetconf.QNAME.getLocalName())));
        KeyedInstanceIdentifier netconfNodeIID = instanceIdentifier.child(Node.class, (Identifier)new NodeKey(nodeId));
        return netconfNodeIID;
    }

    public static YangInstanceIdentifier createNetConfNodeMountPointYII(NodeId nodeId) {
        YangInstanceIdentifier yangInstanceIdentifier = YangInstanceIdentifier.builder().node(NetworkTopology.QNAME).node(Topology.QNAME).nodeWithKey(Topology.QNAME, QName.create((String)NETCONF_TOPOLOGY_NAMESPACE, (String)NETCONF_TOPOLOGY_VERSION, (String)TOPOLOGY_ID), (Object)TOPOLOGY_NETCONF).node(Node.QNAME).nodeWithKey(Node.QNAME, QName.create((String)NETCONF_TOPOLOGY_NAMESPACE, (String)NETCONF_TOPOLOGY_VERSION, (String)NODE_ID), (Object)nodeId.getValue()).build();
        return yangInstanceIdentifier;
    }

    public static ListenableFuture<Optional<NormalizedNode<?, ?>>> extractDataFromRpcResult(Optional<YangInstanceIdentifier> path, ListenableFuture<DOMRpcResult> rpcFuture) {
        return Futures.transform(rpcFuture, result -> {
            Preconditions.checkArgument((boolean)result.getErrors().isEmpty(), (String)"Unable to read data: %s, errors: %s", (Object)path, (Object)result.getErrors());
            DataContainerChild dataNode = (DataContainerChild)((ContainerNode)result.getResult()).getChild((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.toId((QName)NetconfMessageTransformUtil.NETCONF_DATA_QNAME)).get();
            return NormalizedNodes.findNode((NormalizedNode)dataNode, (Iterable)((YangInstanceIdentifier)path.get()).getPathArguments());
        });
    }

    public static DataContainerChild<?, ?> createEditConfigStructure(SchemaContext schemaContext, Optional<NormalizedNode<?, ?>> lastChild, Optional<ModifyAction> operation, YangInstanceIdentifier dataPath) {
        AnyXmlNode configContent = NetconfMessageTransformUtil.createEditConfigAnyxml((SchemaContext)schemaContext, (YangInstanceIdentifier)dataPath, operation, lastChild);
        return (DataContainerChild)Builders.choiceBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.toId((QName)EditContent.QNAME)).withChild((DataContainerChild)configContent).build();
    }

    public static ContainerNode getEditConfigContent(QName targetDatastore, DataContainerChild<?, ?> editStructure, Optional<ModifyAction> defaultOperation, boolean rollback) {
        DataContainerNodeAttrBuilder editBuilder = Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.toId((QName)NetconfMessageTransformUtil.NETCONF_EDIT_CONFIG_QNAME));
        editBuilder.withChild(NetconfUtils.getTargetNode(targetDatastore));
        if (defaultOperation.isPresent()) {
            String opString = defaultOperation.get().name().toLowerCase();
            editBuilder.withChild((DataContainerChild)Builders.leafBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.toId((QName)NetconfMessageTransformUtil.NETCONF_DEFAULT_OPERATION_QNAME)).withValue((Object)opString).build());
        }
        if (rollback) {
            editBuilder.withChild((DataContainerChild)Builders.leafBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.toId((QName)NetconfMessageTransformUtil.NETCONF_ERROR_OPTION_QNAME)).withValue((Object)"rollback-on-error").build());
        }
        editBuilder.withChild(editStructure);
        return (ContainerNode)editBuilder.build();
    }

    public static DataContainerChild<?, ?> getSourceNode(QName sourceDatastore) {
        return (DataContainerChild)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.toId((QName)NetconfMessageTransformUtil.NETCONF_SOURCE_QNAME)).withChild((DataContainerChild)Builders.choiceBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.toId((QName)ConfigSource.QNAME)).withChild((DataContainerChild)Builders.leafBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.toId((QName)sourceDatastore)).withValue((Object)Empty.getInstance()).build()).build()).build();
    }

    public static ContainerNode getLockContent(QName targetDatastore) {
        return (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.toId((QName)NetconfMessageTransformUtil.NETCONF_LOCK_QNAME)).withChild(NetconfUtils.getTargetNode(targetDatastore)).build();
    }

    public static DataContainerChild<?, ?> getTargetNode(QName targetDatastore) {
        return (DataContainerChild)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.toId((QName)NetconfMessageTransformUtil.NETCONF_TARGET_QNAME)).withChild((DataContainerChild)Builders.choiceBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.toId((QName)ConfigTarget.QNAME)).withChild((DataContainerChild)Builders.leafBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.toId((QName)targetDatastore)).withValue((Object)Empty.getInstance()).build()).build()).build();
    }

    public static NormalizedNode<?, ?> getCopyConfigContent(QName sourceDatastore, QName targetDatastore) {
        return Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.toId((QName)NetconfMessageTransformUtil.NETCONF_COPY_CONFIG_QNAME)).withChild(NetconfUtils.getTargetNode(targetDatastore)).withChild(NetconfUtils.getSourceNode(sourceDatastore)).build();
    }

    public static NormalizedNode<?, ?> getDeleteConfigContent(QName targetDatastore) {
        return Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.toId((QName)NETCONF_DELETE_CONFIG_QNAME)).withChild(NetconfUtils.getTargetNode(targetDatastore)).build();
    }

    public static NormalizedNode<?, ?> getValidateContent(QName sourceDatastore) {
        return Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.toId((QName)NetconfMessageTransformUtil.NETCONF_VALIDATE_QNAME)).withChild(NetconfUtils.getSourceNode(sourceDatastore)).build();
    }

    public static NormalizedNode<?, ?> getUnLockContent(QName targetDatastore) {
        return Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.toId((QName)NetconfMessageTransformUtil.NETCONF_UNLOCK_QNAME)).withChild(NetconfUtils.getTargetNode(targetDatastore)).build();
    }
}

