/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.modules.southbound.netconf.impl;

import io.lighty.core.controller.api.AbstractLightyModule;
import io.lighty.core.controller.api.LightyServices;
import java.util.concurrent.ExecutorService;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.netconf.callhome.mount.CallHomeMountDispatcher;
import org.opendaylight.netconf.callhome.mount.IetfZeroTouchCallHomeServerProvider;
import org.opendaylight.netconf.callhome.mount.SchemaRepositoryProviderImpl;
import org.opendaylight.netconf.topology.api.SchemaRepositoryProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfCallhomePlugin
extends AbstractLightyModule {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfCallhomePlugin.class);
    private final IetfZeroTouchCallHomeServerProvider provider;

    public NetconfCallhomePlugin(LightyServices lightyServices, String topologyId, ExecutorService executorService, AAAEncryptionService encryptionService) {
        super(executorService);
        SchemaRepositoryProviderImpl schemaRepositoryProvider = new SchemaRepositoryProviderImpl("shared-schema-repository-impl");
        CallHomeMountDispatcher dispatcher = new CallHomeMountDispatcher(topologyId, lightyServices.getEventExecutor(), lightyServices.getScheduledThreaPool(), lightyServices.getThreadPool(), (SchemaRepositoryProvider)schemaRepositoryProvider, lightyServices.getBindingDataBroker(), lightyServices.getDOMMountPointService(), encryptionService);
        this.provider = new IetfZeroTouchCallHomeServerProvider(lightyServices.getBindingDataBroker(), dispatcher);
    }

    protected boolean initProcedure() {
        this.provider.init();
        return true;
    }

    protected boolean stopProcedure() {
        try {
            this.provider.close();
        }
        catch (Exception e) {
            LOG.error("{} failed to close!", this.provider.getClass(), (Object)e);
            return false;
        }
        return true;
    }
}

