/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.server;

import io.lighty.server.LightyServerBuilder;
import io.lighty.server.config.SecurityConfig;
import java.net.InetSocketAddress;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;

public class Http2LightyServerBuilder
extends LightyServerBuilder {
    private final SecurityConfig securityConfig;

    public Http2LightyServerBuilder(InetSocketAddress inetSocketAddress, SecurityConfig config) {
        super(inetSocketAddress);
        this.securityConfig = config;
    }

    @Override
    public Server build() {
        this.server = new Server();
        Server server = super.build();
        HttpConfiguration httpsConfig = new HttpConfiguration();
        httpsConfig.setSecureScheme(HttpScheme.HTTPS.asString());
        httpsConfig.setSecurePort(this.inetSocketAddress.getPort());
        httpsConfig.setSendXPoweredBy(true);
        httpsConfig.setSendServerVersion(true);
        httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        HTTP2ServerConnectionFactory h2 = new HTTP2ServerConnectionFactory(httpsConfig);
        ALPNServerConnectionFactory alpn = new ALPNServerConnectionFactory(new String[0]);
        alpn.setDefaultProtocol(h2.getProtocol());
        SslConnectionFactory ssl = this.securityConfig.getSslConnectionFactory(alpn.getProtocol());
        ServerConnector sslConnector = new ServerConnector(server, new ConnectionFactory[]{ssl, alpn, h2, new HttpConnectionFactory(httpsConfig)});
        sslConnector.setPort(this.inetSocketAddress.getPort());
        server.addConnector((Connector)sslConnector);
        return server;
    }
}

