/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.server.config;

import java.security.KeyStore;
import org.eclipse.jetty.http2.HTTP2Cipher;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class SecurityConfig {
    private final KeyStore keyStore;
    private final KeyStore trustKeyStore;
    private final String ksPassword;
    private final String trustKsPassword;
    private final SslContextFactory.Server server;
    private final boolean isNeedClientAuth;

    public SecurityConfig(KeyStore keyStore, String ksPassword, KeyStore trustKeyStore, String trustKsPassword, boolean isNeedClientAuth) {
        this.keyStore = keyStore;
        this.ksPassword = ksPassword;
        this.trustKeyStore = trustKeyStore;
        this.trustKsPassword = trustKsPassword;
        this.isNeedClientAuth = isNeedClientAuth;
        this.server = new SslContextFactory.Server();
        this.initFactoryCtx();
    }

    private void initFactoryCtx() {
        this.server.setTrustStore(this.trustKeyStore);
        this.server.setTrustStorePassword(this.trustKsPassword);
        this.server.setKeyStore(this.keyStore);
        this.server.setKeyStorePassword(this.ksPassword);
        this.server.setCipherComparator(HTTP2Cipher.COMPARATOR);
        this.server.setNeedClientAuth(this.isNeedClientAuth);
    }

    public SslConnectionFactory getSslConnectionFactory(String protocol) {
        return new SslConnectionFactory((SslContextFactory)this.server, protocol);
    }
}

