/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.server;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.DispatcherType;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;

public class LightyServerBuilder {
    private final Map<FilterHolder, String> filters;
    private final Map<String, String> parameters;
    private final List<EventListener> listeners;
    protected final InetSocketAddress inetSocketAddress;
    protected final List<Handler> contexts;
    protected Server server;

    public LightyServerBuilder(InetSocketAddress inetSocketAddress) {
        this.inetSocketAddress = inetSocketAddress;
        this.filters = new HashMap<FilterHolder, String>();
        this.parameters = new HashMap<String, String>();
        this.listeners = new ArrayList<EventListener>();
        this.contexts = new ArrayList<Handler>();
    }

    public LightyServerBuilder(Server server) {
        this(new InetSocketAddress(0));
        this.server = server;
    }

    public LightyServerBuilder addCommonFilter(FilterHolder filterHolder, String path) {
        this.filters.put(filterHolder, path);
        return this;
    }

    public LightyServerBuilder addCommonEventListener(EventListener eventListener) {
        this.listeners.add(eventListener);
        return this;
    }

    public LightyServerBuilder addCommonInitParameter(String key, String value) {
        this.parameters.put(key, value);
        return this;
    }

    public LightyServerBuilder addContextHandler(Handler handler) {
        this.contexts.add(handler);
        return this;
    }

    public Server build() {
        if (this.server == null) {
            this.server = new Server(this.inetSocketAddress);
        }
        ContextHandlerCollection contextHandlerCollection = new ContextHandlerCollection();
        this.contexts.forEach(contextHandler -> {
            this.addFilters((Handler)contextHandler);
            contextHandlerCollection.addHandler(contextHandler);
        });
        this.server.setHandler((Handler)contextHandlerCollection);
        return this.server;
    }

    void addFilters(Handler contextHandler) {
        if (contextHandler instanceof ContextHandlerCollection) {
            ContextHandlerCollection sch = (ContextHandlerCollection)contextHandler;
            for (Handler handler : sch.getChildHandlers()) {
                if (!(handler instanceof ServletContextHandler)) continue;
                this.additionalComponents(handler);
            }
        } else if (contextHandler instanceof ServletContextHandler) {
            this.additionalComponents(contextHandler);
        }
    }

    private void additionalComponents(Handler contextHandler) {
        ServletContextHandler ch = (ServletContextHandler)contextHandler;
        this.filters.forEach((filterHolder, path) -> ch.addFilter(filterHolder, path, EnumSet.of(DispatcherType.REQUEST)));
        EventListener[] array = new EventListener[this.listeners.size()];
        array = this.listeners.toArray(array);
        ch.setEventListeners(array);
        this.parameters.forEach((arg_0, arg_1) -> ((ServletContextHandler)ch).setInitParameter(arg_0, arg_1));
    }
}

