/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.server;

import io.lighty.server.LightyServerBuilder;
import java.net.InetSocketAddress;
import java.util.EnumSet;
import java.util.EventListener;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.servlet.DispatcherType;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.jersey.internal.guava.Preconditions;
import org.opendaylight.aaa.web.WebContext;
import org.opendaylight.aaa.web.WebContextRegistration;
import org.opendaylight.aaa.web.WebServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightyWebServerAdapter
extends LightyServerBuilder
implements WebServer {
    private static final Logger LOG = LoggerFactory.getLogger(LightyWebServerAdapter.class);
    private static final int HTTP_SERVER_IDLE_TIMEOUT = 30000;
    private int httpPort;
    private ServerConnector http;
    private ContextHandlerCollection contextHandlerCollection;

    public LightyWebServerAdapter(InetSocketAddress inetSocketAddress, int httpPort) {
        super(inetSocketAddress);
        this.httpPort = httpPort;
        this.serverInit(httpPort);
    }

    public LightyWebServerAdapter(Server server, int httpPort) {
        super(server);
        this.serverInit(httpPort);
    }

    private void serverInit(int port) {
        Preconditions.checkArgument((port >= 0 ? 1 : 0) != 0, (Object)"httpPort must be positive");
        Preconditions.checkArgument((port < 65536 ? 1 : 0) != 0, (Object)"httpPort must < 65536");
        this.contextHandlerCollection = new ContextHandlerCollection();
        if (this.server == null) {
            this.server = new Server(this.inetSocketAddress);
        }
        this.contexts.forEach(contextHandler -> {
            this.addFilters((Handler)contextHandler);
            this.contextHandlerCollection.addHandler(contextHandler);
        });
        this.http = new ServerConnector(this.server);
        this.http.setHost("localhost");
        this.http.setPort(port);
        this.http.setIdleTimeout(30000L);
        this.server.addConnector((Connector)this.http);
    }

    @Override
    public Server build() {
        return this.server;
    }

    public WebContextRegistration registerWebContext(WebContext webContext) {
        Object contextPathWithSlashPrefix = webContext.contextPath().startsWith("/") ? webContext.contextPath() : "/" + webContext.contextPath();
        ServletContextHandler handler = new ServletContextHandler((HandlerContainer)this.contextHandlerCollection, (String)contextPathWithSlashPrefix, webContext.supportsSessions() ? 1 : 0);
        webContext.contextParams().entrySet().forEach(entry -> handler.setAttribute((String)entry.getKey(), entry.getValue()));
        webContext.listeners().forEach(listener -> handler.addEventListener((EventListener)listener));
        webContext.filters().forEach(filter -> {
            FilterHolder filterHolder = new FilterHolder(filter.filter());
            filterHolder.setInitParameters(filter.initParams());
            filter.urlPatterns().forEach(urlPattern -> handler.addFilter(filterHolder, urlPattern, EnumSet.allOf(DispatcherType.class)));
        });
        webContext.servlets().forEach(servlet -> {
            ServletHolder servletHolder = new ServletHolder(servlet.name(), servlet.servlet());
            servletHolder.setInitParameters(servlet.initParams());
            servletHolder.setInitOrder(1);
            servlet.urlPatterns().forEach(urlPattern -> handler.addServlet(servletHolder, urlPattern));
        });
        this.addFilters((Handler)handler);
        this.contextHandlerCollection.addHandler((Handler)handler);
        return () -> this.close(handler);
    }

    public String getBaseURL() {
        if (this.httpPort == 0) {
            throw new IllegalStateException("must start() before getBaseURL()");
        }
        return "http://localhost:" + this.httpPort;
    }

    private void close(ServletContextHandler handler) {
        try {
            handler.stop();
            handler.destroy();
        }
        catch (Exception e) {
            LOG.error("close() failed", (Throwable)e);
        }
        this.contextHandlerCollection.removeHandler((Handler)handler);
    }

    @PostConstruct
    public void start() throws Throwable {
        this.server.start();
        this.httpPort = this.http.getLocalPort();
        LOG.info("Started Jetty-based HTTP web server on port {} ({}).", (Object)this.httpPort, (Object)this.hashCode());
    }

    @PreDestroy
    public void stop() throws Exception {
        LOG.info("Stopping Jetty-based web server...");
        this.server.stop();
        LOG.info("Stopped Jetty-based web server.");
    }
}

